#!/usr/bin/env python2

from mapreducelib import Record, MapReduce as MR
from logparse import parseReqans
from mymrutils import *
from itertools import islice
import re
from hashlib import md5
import random
from collections import defaultdict

def main():
    MR.useDefaults(username='snippets', server='cedar00.search.yandex.net:8013', verbose=True)
    DST = 'likhomanov/bno_inner_cnt'
    DST_S = 'likhomanov/bno_inner_sample'
    with mktmp() as tmp:
        for src in ['reqans_log/{}'.format(d) for d in strdaterange((2015,4,27), (2015,4,30))]:
            MR.runCombine(getData, srcTable=src, dstTables=[tmp, DST_S], appendMode=True)
        MR.runReduce(Summarizer(), srcTable=tmp, dstTable=DST)

def getData(recs):
    d = defaultdict(int)
    for rec in recs:
        req, ress = parseReqans(rec.value)
        if req.get('stype') != 'www':
            continue
        if req.get('is_yandex', '0') == '1':
            continue
        lang = serpLang(req)
        if lang not in ('ru', 'ua', 'by', 'kz'):
            continue
        serp = bno = inner = False
        for res in ress:
            url = res.get('url')
            if url and 'snippets_type' in res:
                serp = True
                d['doc'] += 1
            else:
                continue
            extra = res.get('extralinks')
            if extra and 'bno' in extra:
                bno = True
                d['bno'] += 1
                if getInnerPath(url) not in ('', '/', None):
                    inner = True
                    d['inner'] += 1
                    yield Record('0', '', '{}\t{}'.format(req['req'], url), tableIndex=1)
        if serp:
            d['serp'] += 1
        if bno:
            d['serpbno'] += 1
        if inner:
            d['serpinner'] += 1
    for k, v in d.iteritems():
        yield Record(k, '', str(v), tableIndex=0)

if __name__ == '__main__':
    main()

