#!/usr/bin/env python2

from mapreducelib import Record, TemporaryTable, MapReduce as MR
from reqansparse import parseRARecord
from itertools import islice
import re
from hashlib import md5
import random

serpRE = re.compile(r'https?://(www\.)?yandex\.([^/]*)/yandsearch')
needed = 1000

def main():
    MR.useDefaults(username='snippets', server='cedar00.search.yandex.net:8013', verbose=True)
    mktmp = lambda: TemporaryTable(project='likhomanov')
    mrsort = lambda table: MR.sortTable(srcTable=table.name, dstTable=table.name)
    with mktmp() as tmp, mktmp() as tmpsample:
        for src in ['reqans_log/201406{:02}'.format(i) for i in (4,)]:
            MR.runMap(getchords, srcTable=src, dstTable=tmp.name)
        mrsort(tmp)
        MR.runReduce(count_and_sample, srcTable=tmp.name, dstTables=[tmp.name, tmpsample.name])
        mrsort(tmp)
        mrsort(tmpsample)
        MR.runReduce(getNeeded, srcTable=tmp.name, dstTable='likhomanov/chordstop')
        MR.runReduce(getNeeded, srcTable=tmpsample.name, dstTable='likhomanov/chordsrnd')

def serpLang(url):
    if not url:
        return None
    m = re.match(serpRE, url)
    if not m:
        return None
    return m.group(2)

def getchords(rec):
    ra = parseRARecord(rec.value)
    if ra['request'].get('stype') != 'www':
        return
    if ra['request'].get('is_yandex', '0') == '1':
        return
    lang = serpLang(ra['request'].get('serp_url'))
    if lang not in ('ru', 'ua', 'by', 'kz'):
        return
    haveChords = False
    for res in ra['results']:
        stype = res.get('snippets_type')
        if stype != 'chords':
            continue
        haveChords = True
    if haveChords:
        req = ra['request']['req']
        yield Record(md5(req).hexdigest(), '', req)

def count_and_sample(key, recs):
    r = next(recs)
    yield Record('0', str(random.random()), r.value, tableIndex=1)
    n = 1
    for _ in recs:
        n += 1
    yield Record('0', str(100000000 - n), r.value, tableIndex=0)

def getNeeded(key, recs):
    for rec in islice(recs, needed):
        yield rec

if __name__ == '__main__':
    main()

