#!/usr/bin/env python2

from mapreducelib import Record, TemporaryTable, MapReduce as MR
#from logparse import parseReqans
import libra
from mymrutils import *
import re
from hashlib import md5
import random
from collections import defaultdict


dates = ['20140104', '20140105', '20140111', '20140123', '20140129', '20140202', '20140205', '20140208', '20140217', '20140223', '20140308', '20140309', '20140313', '20140318', '20140326', '20140413', '20140417', '20140425', '20140426', '20140428', '20140502', '20140503', '20140507', '20140525', '20140527', '20140612', '20140615', '20140625', '20140629', '20140630', '20140705', '20140710', '20140714', '20140719', '20140720']

def main():
    MR.useDefaults(username='snippets', server='cedar00.search.yandex.net:8013', verbose=True, files=['blockstat.dict'])
    DST = 'likhomanov/tr_addr_total'
    with mktmp() as tmp, open('log0', 'w') as logf:
        for src in ['user_sessions/{}'.format(d) for d in dates]:
            MR.runReduce(getData, srcTable=src, dstTable=tmp)
            print >>logf, src, 'read'
            logf.flush()
            MR.runCombine(summarize, srcTable=tmp, dstTable=DST, appendMode=True)
            print >>logf, src, 'combined'
            logf.flush()
            MR.runReduce(Summarizer(), srcTable=DST, dstTable=DST)
            print >>logf, src, 'summed'
            logf.flush()

def getData(key, recs):
    try:
        for req in libra.ParseSessionWithFat(recs, 'blockstat.dict'):
            if not req.IsA('TYandexWebRequest'):
                continue
            if req.ServiceDomRegion != 'tr':
                continue
            yield Record('0', '', '1')
    except (NameError, AttributeError, TypeError):
        raise
    except Exception:
        pass

def summarize(recs):
    n = 0
    for rec in recs:
        n += int(rec.value)
    yield Record('0', '', str(n))

if __name__ == '__main__':
    main()

