#!/usr/bin/env python2

from mapreducelib import Record, MapReduce as MR
from logparse import parseReqans
from mymrutils import *
import random
from hashlib import md5
from collections import defaultdict
import re

def main():
    MR.useDefaults(username='snippets', server='cedar00.search.yandex.net:8013', verbose=True)
    DST = 'likhomanov/counts_2787'
    with mktmp() as tmp:
        for src in ['reqans_log/{}'.format(d) for d in strdaterange((2015,2,9), (2015,2,12))]:
            MR.runCombine(getData, srcTable=src, dstTable=tmp, appendMode=True)
            MR.runReduce(Limiter(1), srcTable=tmp, dstTable=tmp)
        MR.runCombine(aggregate, srcTable=tmp, dstTable=tmp)
        MR.runReduce(Summarizer(), srcTable=tmp, dstTable=DST)

masks = {
        'ru.wikipedia.org/wiki/*': r'ru\.wikipedia\.org/wiki/.*',
        'www.kinopoisk.ru/film/*': r'kinopoisk\.ru/film/.*',
        'kinogo.net/*.html': r'kinogo\.net/.*\.html$',
        'bigcinema.tv/*/*.html': r'bigcinema\.tv/.*/.*\.html$',
        'bobfilm.net/*/*.html': r'bobfilm\.net/.*/.*\.html$',
        '~odnoklassnikihelp.com/category/*': r'odnoklassnikihelp.com/(?!category/.*)',
        'lenta.ru/news/**': r'lenta\.ru/news/.*',
        'kakprosto.ru/kak-*': r'kakprosto\.ru/kak-.*',
        'ivi.ru/news/novost/*': r'ivi\.ru/news/novost/.*',
        'fb.ru/article/**': r'fb\.ru/article/.*',
        'tushkan.net/publ/**': r'tushkan\.net/publ/.*',
        'profi-forex.org/**.html': r'profi-forex\.org/.*\.html$',
        'films.imhonet.ru/element/*': r'films\.imhonet\.ru/element/.*',
        'rutor.org/torrent/**': r'rutor\.org/torrent/.*',
        'my-hit.org/film/*': r'my-hit\.org/film/.*',
        'onlainfilm.ucoz.ua/load/*/*': r'onlainfilm\.ucoz\.ua/load/.*/.*',
        'zerx.tv/*.html': r'zerx\.tv/.*\.html$',
        'seasonvar.ru/serial-*.html': r'seasonvar\.ru/serial-.*\.html$',
        'fast-torrent.ru/film/*.html': r'fast-torrent\.ru/film/.*\.html$',
        'lurkmore.to/*': r'lurkmore\.to/.*',
        'wikireality.ru/wiki/*': r'wikireality\.ru/wiki/.*',
        'onlinemultfilmy.ru/*': r'onlinemultfilmy\.ru/.*',
        'womanadvice.ru/*': r'womanadvice\.ru/.*',
        'en.wikipedia.org/wiki/*': r'en\.wikipedia\.org/wiki/.*',
        'kino-teatr.ru/**': r'kino-teatr\.ru/.*',
        'torrentino.com/torrents/*': r'torrentino\.com/torrents/.*',
        'play.google.com/store/*/details/*': r'play\.google\.com/store/.*/details/.*',
        'tfilm.tv/*.html': r'tfilm\.tv/.*\.html$',
        'afisha.mail.ru/cinema/*/*': r'afisha\.mail\.ru/cinema/.*/.*',
        'woman.ru/**/article/*': r'woman\.ru/.*/article/.*'
        }

for m in masks:
    masks[m] = re.compile(masks[m])

def getMask(url):
    url = url.lower()
    if url.startswith('http://'):
        url = url[7:]
    elif url.startswith('https://'):
        url = url[8:]
    if url.startswith('www.'):
        url = url[4:]
    for m in masks:
        if masks[m].match(url):
            return m
    return None

def getData(recs):
    for rec in recs:
        req, ress = parseReqans(rec.value)
        if not iswww(req):
            continue
        if serpLang(req) != 'ru':
            continue
        for res in ress:
            if 'snippets_type' not in res:
                continue
            url = res['url']
            mask = getMask(url)
            if mask:
                yield Record(md5(url).hexdigest(), '', mask)

def aggregate(recs):
    d = defaultdict(int)
    for rec in recs:
        d[rec.value] += 1
    for k, v in d.iteritems():
        yield Record(k, '', str(v))

if __name__ == '__main__':
    main()

