#!/usr/bin/env python2

from mapreducelib import Record, TemporaryTable, MapReduce as MR
from logparse import parseReqans
from mymrutils import *
from itertools import islice
import re
from hashlib import md5
import random
from datetime import date, timedelta

fhosts = set(l.strip() for l in open('form_hosts'))

def main():
    MR.useDefaults(username='snippets', server='cedar00.search.yandex.net:8013', verbose=True, files=['form_hosts'])
    DST = 'likhomanov/form_stat'
    with mktmp() as tmp, mktmp() as tmpf:
        for src in ['reqans_log/{}'.format((date(2014, 7, 28) + timedelta(days=i)).strftime('%Y%m%d')) for i in range(7)]:
            MR.runMap(getData, srcTable=src, dstTable=tmp.name)
            MR.runMap(cat, srcTable='likhomanov/form_urls', dstTable=tmp.name, appendMode=True)
            MR.runReduce(getForms, srcTable=tmp.name, dstTable=tmpf.name, appendMode=True)
        MR.runReduce(Summarizer(), srcTable=tmpf.name, dstTable=DST)

def getData(rec):
    req, ress = parseReqans(rec.value)
    checkwww(req)
    for res in ress:
        url = res.get('url')
        host = getHost(url)
        if host not in fhosts:
            continue
        yield Record(url, '1', '')

def getForms(url, recs):
    r = next(recs)
    if r.subkey != '0':
        return
    form = r.value
    n = 0
    for _ in recs:
        n += 1
    if n:
        yield Record(form, '', str(n))

if __name__ == '__main__':
    main()


