#!/usr/bin/env python2

from mapreducelib import Record, MapReduce as MR
from logparse import parseReqans
from mymrutils import *
from itertools import islice
import re
from hashlib import md5
import random
from collections import defaultdict

def main():
    MR.useDefaults(username='snippets', server='cedar00.search.yandex.net:8013', verbose=True)
    DST = 'likhomanov/forum_sample'
    with mktmp() as tmp:
        for src in ['reqans_log/{}'.format(d) for d in strdaterange((2014,10,20), (2014,10,27))]:
            MR.runCombine(getData, srcTable=src, dstTable=tmp, appendMode=True)
        MR.runReduce(uniq, srcTable=tmp, dstTable=tmp)
        MR.runReduce(Limiter(100000), srcTable=tmp, dstTable=DST)

def getData(recs):
    for rec in recs:
        req, ress = parseReqans(rec.value)
        if req.get('stype') != 'www':
            continue
        if req.get('is_yandex', '0') == '1':
            continue
        lang = serpLang(req)
        if lang not in ('ru', 'ua', 'by', 'kz', 'com.tr'):
            continue
        if lang == 'com.tr':
            lang = 'tr'
        else:
            lang = 'kubr'
        query = req['req']
        for res in ress:
            if 'forum' in res.get('snippets_type', ''):
                ru = query + '\t' + res['url']
                yield Record(lang + '\t' + md5(ru).hexdigest(), '', ru)

def uniq(key, recs):
    lang, _ = key.split('\t')
    r = next(recs)
    yield Record(lang, str(random.random()), r.value)

if __name__ == '__main__':
    main()

