#!/usr/bin/env python2

from mapreducelib import Record, MapReduce as MR
from logparse import parseReqans
from mymrutils import *
import random
import libra

def main():
    MR.useDefaults(username='snippets', server='cedar00.search.yandex.net:8013', verbose=True, files=['blockstat.dict'])
    DST = 'likhomanov/forum_bno'
    with mktmp() as tmp:
        for src in ['user_sessions/{}'.format(d) for d in strdaterange((2015,2,23), (2015,3,2))]:
        #for src in ['user_sessions/{}'.format(d) for d in strdaterange((2015,2,25), (2015,2,26))]:
            MR.runReduce(getData, srcTable=src, dstTable=tmp, appendMode=True)
            MR.runReduce(Summarizer(), srcTable=tmp, dstTable=tmp)
        MR.copyTable(srcTable=tmp, dstTable=DST)


def getData(key, recs):
    try:
        for req in libra.ParseSession(recs, 'blockstat.dict'):
            if not req.IsA('TYandexWebRequest'):
                continue
            lang = req.ServiceDomRegion
            if lang not in ('tr', ):
                continue
            bno = (req.SearchPropsValues.get('WEB.BigNavAnswer.work') in (1, '1'))
            forum = None
            for block in req.GetMainBlocks():
                res = block.GetMainResult()
                if not res.IsA('TWebResult'):
                    continue
                if res.Position == 0:
                    stype = res.SnippetType
                    if 'forum' in stype:
                        forum = stype
                    break
                elif res.Position > 0:
                    break
            yield Record('ALL', '' ,'1')
            if bno:
                yield Record('bno', '', '1')
                if forum:
                    yield Record('bno ' + forum, '', '1')
            if forum:
                yield Record(forum, '', '1')
    except (NameError, AttributeError, TypeError):
        raise
    except Exception:
        pass

if __name__ == '__main__':
    main()

