#!/usr/bin/env python2

from mapreducelib import Record, MapReduce as MR
from logparse import parseReqans
from mymrutils import *
from hashlib import md5

hashes = set(l.strip() for l in open('forumhashes'))

def main():
    MR.useDefaults(username='snippets', server='cedar00.search.yandex.net:8013', verbose=True, files=['forumhashes'])
    DST = 'likhomanov/ftopicnew'
    MR.runCombine(getData, srcTable='reqans_log/20150302', dstTable=DST)
    MR.runReduce(Limiter(1), srcTable=DST, dstTable=DST)
    mrsort(DST)

def getData(recs):
    for rec in recs:
        req, ress = parseReqans(rec.value)
        if not iswww(req):
            continue
        lang = serpLang(req)
        if lang == 'com.tr':
            lang = 'tr'
        elif lang != 'ru':
            continue
        for res in ress:
            stype = res.get('snippets_type')
            if not stype or stype == ('forum_topic' if lang == 'ru' else 'forum_forums'):
                continue
            s = '{}\t{}\t{}'.format(lang, req['req'], res['url'])
            h = md5(s).hexdigest()
            if h in hashes:
                yield Record(h, '1', s)

if __name__ == '__main__':
    main()

