#!/usr/bin/env python2

from mapreducelib import Record, TemporaryTable, MapReduce as MR
from logparse import parseReqans
from mymrutils import *
import re


def main():
    MR.useDefaults(username='snippets', server='cedar00.search.yandex.net:8013', verbose=True)
    DST = 'likhomanov/kubr_top_hosts_aug'
    with open('log1', 'w') as log:
        with mktmp() as tmp:
            for src in ['reqans_log/{}'.format(d) for d in strdaterange((2014, 8, 25), (2014, 9, 1))]:
                MR.runMap(getData, srcTable=src, dstTable=tmp)
                print >>log, src, 'consumed'
                log.flush()
                MR.runReduce(Summarizer(limit=1000), srcTable=tmp, dstTable=DST, appendMode=True)
                MR.runReduce(Summarizer(), srcTable=DST, dstTable=DST)
                print >>log, src, 'merged'
                log.flush()
            MR.runMap(presort, srcTable=DST, dstTable=DST)
            MR.runReduce(Limiter(10000), srcTable=DST, dstTable=DST)

def getData(rec):
    req, ress = parseReqans(rec.value)
    checkwww(req)
    if serpLang(req) not in ('ru', 'ua', 'by', 'kz'):
        return
    for res in ress:
        if 'snippets_type' not in res:
            continue
        url = res.get('url')
        host = getHost(url)
        if host:
            yield Record(host, '', '1')
            inner = getInnerPath(url)
            if inner:
                parts = [p for p in re.split(r'([/?]+)', inner) if p]
                if parts:
                    host += parts[0]
                    parts = parts[1:]
                    i = 0
                    while parts and i < 5:
                        host += ''.join(parts[:2])
                        if len(host) < 4096:
                            yield Record(host, '', '1')
                        parts = parts[2:]


def presort(rec):
    n = int(rec.value)
    yield Record('0', str(10000000000 - n), rec.key + '\t' + rec.value)

if __name__ == '__main__':
    main()

