#!/usr/bin/env python2

from mapreducelib import Record, MapReduce as MR
from logparse import parseReqans
from mymrutils import *
from itertools import islice
import re
from hashlib import md5
import random
from collections import defaultdict

addr = set(l.strip() for l in open('true_addr'))


def main():
    MR.useDefaults(username='snippets', server='cedar00.search.yandex.net:8013', verbose=True, files=['true_addr'])
    DST = 'likhomanov/addr_counts'
    with mktmp() as tmp:
        for src in ['reqans_log/{}'.format(d) for d in strdaterange((2014,10,27), (2014,10,30))]:
            MR.runCombine(getData, srcTable=src, dstTable=tmp, appendMode=True)
        MR.runReduce(summarize, srcTable=tmp, dstTable=tmp)
        MR.sortTable(srcTable=tmp, dstTable=DST)

def getData(recs):
    d = defaultdict(int)
    for rec in recs:
        req, ress = parseReqans(rec.value)
        if req.get('stype') != 'www':
            continue
        if req.get('is_yandex', '0') == '1':
            continue
        lang = serpLang(req)
        if lang not in ('ru', 'ua', 'by', 'kz'):
            continue
        for res in ress:
            if 'snippets_type' not in res:
                continue
            url = res['url']
            if url in addr:
                d[url] += 1
    for k, v in d.iteritems():
        yield Record(k, '', str(v))

def summarize(key, recs):
    n = 0
    for r in recs:
        n += int(r.value)
    yield Record('0', str(10000000 - n), '{}\t{}'.format(key, n))

if __name__ == '__main__':
    main()

