#!/usr/bin/env python2

from mapreducelib import Record, MapReduce as MR
from logparse import parseReqans
from mymrutils import *
from itertools import islice
import re
from hashlib import md5
import random
from collections import defaultdict

def main():
    MR.useDefaults(username='snippets', server='cedar00.search.yandex.net:8013', verbose=True)
    DST = 'likhomanov/otvet'
    with mktmp() as tmp:
        for src in ['reqans_log/{}'.format(d) for d in strdaterange((2014,10,27), (2014,10,30))]:
            MR.runCombine(getData, srcTable=src, dstTable=tmp, appendMode=True)
        MR.runReduce(Summarizer(), srcTable=tmp, dstTable=DST)

def getData(recs):
    d = defaultdict(int)
    for rec in recs:
        req, ress = parseReqans(rec.value)
        if req.get('stype') != 'www':
            continue
        if req.get('is_yandex', '0') == '1':
            continue
        lang = serpLang(req)
        if lang not in ('ru', 'ua', 'by', 'kz'):
            continue
        haveMain = haveInner = serpOK = False
        for res in ress:
            if 'snippets_type' not in res:
                continue
            serpOK = True
            d['docs'] += 1
            url = res['url']
            if getHost(url) != 'otvet.mail.ru':
                continue
            inner = getInnerPath(url)
            if inner and len(inner) > 1:
                d['inner'] += 1
                haveInner = True
            else:
                d['main'] += 1
                haveMain = True
        if serpOK:
            d['serp'] += 1
            if haveInner:
                d['serp inner'] += 1
            if haveMain:
                d['serp main'] += 1
    for k, v in d.iteritems():
        yield Record(k, '', str(v))

if __name__ == '__main__':
    main()

