#!/usr/bin/python2.7

from mapreducelib import Record
import libra
import os, sys

def mkRecord(s):
    key, subkey, content = s.strip().split('\t', 2)
    return Record(key, subkey, content)

def formatSession(record):
    req = libra.ParseSessionWithFat([record], 'blockstat.dict')[0]
    if not req.IsA('TYandexWebRequest'):
        return
    urls = []
    for block in req.GetMainBlocks():
        res = block.GetMainResult()
        if not res.IsA('TWebResult'):
            continue
        urls.append('url:"' + res.Url + '"')
    return '{0}\t({1})\t{2}\t{3}'.format(req.Query, ' | '.join(urls), req.UserRegion, req.ServiceDomRegion)

for l in sys.stdin:
    try:
        f = formatSession(mkRecord(l))
    except Exception as e:
        f = None
        print >>sys.stderr, e
    if f:
        print f

