#!/usr/bin/env python2

from mapreducelib import Record, MapReduce as MR
from logparse import parseReqans
from mymrutils import *

def main():
    MR.useDefaults(username='snippets', server='cedar00.search.yandex.net:8013', verbose=True)
    DST = 'likhomanov/prodoff_tr'
    with mktmp() as tmp:
        for src in ['reqans_log/{}'.format(d) for d in strdaterange((2015, 1, 19), (2015, 1, 20))]:
            MR.runCombine(getData, srcTable=src, dstTable=tmp, appendMode=True)
        MR.runReduce(Summarizer(), srcTable=tmp, dstTable=tmp)
        MR.runMap(presort, srcTable=tmp, dstTable=tmp)
        MR.runReduce(Limiter(50), srcTable=tmp, dstTable=DST)

def getData(recs):
    for rec in recs:
        req, ress = parseReqans(rec.value)
        if not iswww(req):
            continue
        if serpLang(req) != 'com.tr':
            continue
        for res in ress:
            if res.get('snippets_type') == 'productoffer_snip':
                yield Record(getHost(res['url']), '', '1')

def presort(rec):
    n = int(rec.value)
    yield Record('0', str(100000000 - n), rec.key + '\t' + rec.value)

if __name__ == '__main__':
    main()

