#!/usr/bin/env python2

from mapreducelib import Record, MapReduce as MR
from logparse import parseReqans
from mymrutils import *
from collections import defaultdict

rhosts = set()
for l in open('rechosts'):
    l = l.strip()
    if l.startswith('www.'):
        l = l[4:]
    rhosts.add(l)


def main():
    MR.useDefaults(username='snippets', server='cedar00.search.yandex.net:8013', verbose=True, files=['rechosts'])
    DST = 'likhomanov/recipe_xml'
    with mktmp() as tmp:
        for src in ['reqans_log/{}'.format(d) for d in strdaterange((2014,12,16), (2014,12,17))]:
            MR.runCombine(getRecipes, srcTable=src, dstTable=tmp, appendMode=True)
        MR.runReduce(summarize, srcTable=tmp, dstTable=DST)
        mrsort(DST)

def getRecipes(recs):
    d = defaultdict(int)
    for rec in recs:
        req, ress = parseReqans(rec.value)
        if req.get('stype') != 'www':
            continue
        if req.get('is_yandex', '0') != '1':
            continue
        lang = serpLang(req)
        if lang not in ('ru', 'ua', 'by', 'kz'):
            continue
        for res in ress:
            if not res.get('snippets_type') :
                continue
            host = getHost(res['url'])
            if host in rhosts:
                d[lang + '\t' + host] += 1
    for k, v in d.iteritems():
        yield Record(k, '', str(v))

def summarize(key, recs):
    lang, host = key.split('\t')
    n = 0
    for r in recs:
        n += int(r.value)
    yield Record(lang, str(1000000 - n), str(n) + '\t' + host)

if __name__ == '__main__':
    main()

