#!/usr/bin/env python2

from mapreducelib import Record, MapReduce as MR
from logparse import parseReqans
from mymrutils import *
import random
import libra

NEEDED = 10000

def main():
    MR.useDefaults(username='snippets', server='cedar00.search.yandex.net:8013', verbose=True, files=['blockstat.dict'])
    DST = 'likhomanov/sahi_us'
    with mktmp() as tmp:
        for src in ['user_sessions/{}'.format(d) for d in strdaterange((2015,1,1), (2015,2,1))]:
            MR.runReduce(getData, srcTable=src, dstTable=tmp, appendMode=True)
            MR.runReduce(Summarizer(), srcTable=tmp, dstTable=tmp)
        MR.runMap(presort, srcTable=tmp, dstTable=DST)
        mrsort(DST)

def getData(key, recs):
    try:
        for req in libra.ParseSession(recs, 'blockstat.dict'):
            if not req.IsA('TYandexWebRequest'):
                continue
            lang = req.ServiceDomRegion
            if lang != 'tr':
                continue
            for block in req.GetMainBlocks():
                res = block.GetMainResult()
                if not res.IsA('TWebResult'):
                    continue
                url = res.Url
                if getHost(url) != 'sahibinden.com':
                    continue
                yield Record(url, '', '1')
    except (NameError, AttributeError, TypeError):
        raise
    except Exception:
        pass

def presort(rec):
    n = int(rec.value)
    yield Record('0', str(10000000000 - n), '{}\t{}'.format(n, rec.key))

if __name__ == '__main__':
    main()

