#!/usr/bin/env python2

from mapreducelib import Record, MapReduce as MR
from logparse import parseReqans
from mymrutils import *
from itertools import islice
import re
from hashlib import md5
import random
from collections import defaultdict

def main():
    MR.useDefaults(username='snippets', server='cedar00.search.yandex.net:8013', verbose=True)
    DST = 'likhomanov/movie_stat'
    DSTS = 'likhomanov/movie_sample'
    with mktmp() as tmp, mktmp() as tmpsample:
        for src in ['reqans_log/{}'.format(d) for d in strdaterange((2014,11,10), (2014,11,11))]:
            MR.runCombine(getData, srcTable=src, dstTables=[tmp, tmpsample], appendMode=True)
        MR.runReduce(Summarizer(), srcTable=tmp, dstTable=DST)
        MR.runReduce(Limiter(1000), srcTable=tmpsample, dstTable=DSTS)

def getData(recs):
    d = defaultdict(int)
    for rec in recs:
        req, ress = parseReqans(rec.value)
        if req.get('stype') != 'www':
            continue
        if req.get('is_yandex', '0') == '1':
            continue
        lang = serpLang(req)
        if lang == 'com.tr':
            lang = 'tr'
        elif lang in ('ru', 'ua', 'by', 'kz'):
            lang = 'kubr'
        else:
            continue
        for res in ress:
            stype = res.get('snippets_type')
            if not stype:
                continue
            d[lang + ' ALL'] += 1
            if stype == 'schema_movie':
                d[lang + ' schema'] += 1
            elif stype == 'movie':
                d[lang + ' movie'] += 1
                yield Record(lang, str(random.random()), req['req'], tableIndex=1)
    for k, v in d.iteritems():
        yield Record(k, '', str(v), tableIndex=0)

if __name__ == '__main__':
    main()

