#!/usr/bin/env python2

from mapreducelib import Record, TemporaryTable, MapReduce as MR
from logparse import parseReqans
from mymrutils import *
from itertools import islice
import re
from hashlib import md5
import random
from collections import defaultdict

sls = {}
for l in open('sitelinks'):
    l = l.strip()
    for sch in ('http://', 'https:/'):
        for pfx in ('www.', ''):
            for sfx in ('/', ''):
                sls[sch + pfx + l + sfx] = l

def main():
    MR.useDefaults(username='snippets', server='cedar00.search.yandex.net:8013', verbose=True, files=['sitelinks'])
    DST = 'likhomanov/sl_stats'
    with mktmp() as tmp:
        for src in ['reqans_log/{}'.format(d) for d in strdaterange((2014,10,22), (2014,10,23))]:
            MR.runCombine(getData, srcTable=src, dstTable=tmp, appendMode=True)
        #MR.runMap(cat1, srcTable='evilenka/hasrecipe/reduced', dstTable=tmp, appendMode=True)
        MR.runReduce(Summarizer(), srcTable=tmp, dstTable=DST)


def getData(recs):
    d = defaultdict(int)
    for rec in recs:
        req, ress = parseReqans(rec.value)
        if req.get('stype') != 'www':
            continue
        if req.get('is_yandex', '0') == '1':
            continue
        lang = serpLang(req)
        if lang not in ('ru', 'ua', 'by', 'kz', 'com.tr'):
            continue
        if lang == 'com.tr':
            lang = 'tr'
        else:
            lang = 'kubr'
        for res in ress:
            if not res.get('snippets_type'):
                continue
            url = res.get('url')
            if not url:
                continue
            d[lang + 'ALL'] += 1
            if url in sls:
                d[lang + ' ' + sls[url]] += 1
    for k, v in d.iteritems():
        yield Record(k, '', str(v))

if __name__ == '__main__':
    main()

