#!/usr/bin/env python2

from mapreducelib import Record, TemporaryTable, MapReduce as MR
from logparse import parseReqans
from mymrutils import *
from itertools import islice
from collections import defaultdict
import random

def main():
    MR.useDefaults(username='snippets', server='cedar00.search.yandex.net:8013', verbose=True)
    DST = 'likhomanov/specsnips_sample'
    with mktmp() as tmp:
        for src in ['reqans_log/{}'.format(d) for d in strdaterange((2014, 9, 1), (2014, 9, 3))]:
            MR.runCombine(getstype, srcTable=src, dstTable=tmp, appendMode=True)
        MR.runReduce(Limiter(50), srcTable=tmp, dstTable=DST)

def getstype(recs):
    for rec in recs:
        req, ress = parseReqans(rec.value)
        if req.get('stype') != 'www':
            continue
        if req.get('is_yandex', '0') == '1':
            continue
        lang = serpLang(req)
        if lang not in ('ru', 'ua', 'by', 'kz', 'com.tr'):
            continue
        if lang == 'com.tr':
            lang = 'tr'
        else:
            lang = 'kubr'
        for res in ress:
            stype = res.get('snippets_type')
            if not stype:
                continue
            if stype in ('generic', 'dmoz', 'yaca', 'empty', 'ruwiki'):
                continue
            yield Record(lang + ' ' + stype, str(random.random()), '{}\t{}'.format(req['req'], res['url']))

if __name__ == '__main__':
    main()

