#!/usr/bin/env python2

from mapreducelib import Record, TemporaryTable, MapReduce as MR
import libra
from mymrutils import *
from itertools import islice
from collections import defaultdict

def main():
    MR.useDefaults(username='snippets', server='cedar00.search.yandex.net:8013', verbose=True, files=['blockstat.dict'])
    DST = 'likhomanov/specnips_us'
    with mktmp() as tmp:
        for src in ['user_sessions/{}'.format(d) for d in strdaterange((2014, 11, 13), (2014, 11, 14))]:
            MR.runReduce(getstype, srcTable=src, dstTable=tmp, appendMode=True)
        MR.runCombine(mrg, srcTable=tmp, dstTable=tmp)
        MR.runReduce(Summarizer(), srcTable=tmp, dstTable=DST)

def getstype(key, recs):
    try:
        for req in libra.ParseSessionWithFat(recs, 'blockstat.dict'):
            if not req.IsA('TYandexWebRequest'):
                continue
            if req.ServiceDomRegion not in ('ru', 'ua', 'by', 'kz', 'tr'):
                continue
            for block in req.GetMainBlocks():
                res = block.GetMainResult()
                if not res.IsA('TWebResult'):
                    continue
                yield Record(req.ServiceDomRegion, '', res.SnippetType)
                yield Record(req.ServiceDomRegion, '', 'ALL')
    except (NameError, AttributeError, TypeError):
        raise
    except Exception:
        pass

def mrg(recs):
    d = defaultdict(int)
    for r in recs:
        d[r.key + ' ' + r.value] += 1
    for k, v in d.iteritems():
        yield Record(k, '', str(v))

if __name__ == '__main__':
    main()

