#!/usr/bin/env python2

from mapreducelib import Record, TemporaryTable, MapReduce as MR
import libra
from mymrutils import *
from itertools import islice
from collections import defaultdict

def main():
    MR.useDefaults(username='snippets', server='cedar00.search.yandex.net:8013', verbose=True, files=['blockstat.dict'])
    DST = 'likhomanov/specsnips_us'
    with mktmp() as tmp:
        for src in ['user_sessions/{}'.format(d) for d in strdaterange((2015, 5, 20), (2015, 5, 22))]:
            MR.runReduce(getstype, srcTable=src, dstTable=tmp, appendMode=True)
        MR.runCombine(mrg, srcTable=tmp, dstTable=tmp)
        MR.runReduce(Summarizer(), srcTable=tmp, dstTable=DST)

def getstype(key, recs):
    try:
        for req in libra.ParseSession(recs, 'blockstat.dict'):
            if not any(req.IsA(t) for t in ('TYandexWebRequest', 'TMobileYandexWebRequest', 'TTouchYandexWebRequest')):
                continue
            if req.ServiceDomRegion not in ('ru', 'ua', 'by', 'kz', 'tr'):
                continue
            for block in req.GetMainBlocks():
                res = block.GetMainResult()
                if not res.IsA('TWebResult'):
                    continue
                yield Record(req.ServiceDomRegion, '', res.SnippetType, tableIndex=0)
    except (NameError, AttributeError, TypeError):
        raise
    except Exception:
        pass

def mrg(recs):
    d = defaultdict(int)
    for r in recs:
        d[r.key + ' ' + r.value] += 1
    for k, v in d.iteritems():
        yield Record(k, '', str(v))

if __name__ == '__main__':
    main()

