#!/usr/bin/env python2

from mapreducelib import Record, MapReduce as MR
import libra
from mymrutils import *
import random
import re

hosts = [getHost(l.strip()) for l in open('se_hosts.txt')]

def main():
    MR.useDefaults(username='snippets', server='cedar00.search.yandex.net:8013', files=['blockstat.dict', 'se_hosts.txt'], verbose=True)
    DST = 'likhomanov/sx_3038'
    with mktmp() as tmp:
        for src in ['user_sessions/{}'.format(d) for d in strdaterange((2015, 5, 25), (2015, 6, 1))]:
            MR.runReduce(getData, srcTable=src, dstTable=tmp, appendMode=True)
            MR.runReduce(Summarizer(), srcTable=tmp, dstTable=tmp)
        MR.runMap(cleankey, srcTable=tmp, dstTable=tmp)
        MR.runReduce(Summarizer(), srcTable=tmp, dstTable=DST)

def getData(key, recs):
    try:
        for req in libra.ParseSession(recs, 'blockstat.dict'):
            if not req.IsA('TYandexWebRequest'):
                continue
            pfx = str(random.randrange(256)) + '\t'
            if req.ServiceDomRegion != 'ru':
                continue
            found = set()
            for block in req.GetMainBlocks():
                res = block.GetMainResult()
                if not res.IsA('TWebResult'):
                    continue
                host = getHost(res.Url)
                if host not in hosts:
                    continue
                inner = getInnerPath(res.Url)
                if inner and inner.startswith('/questions/'):
                    found.add(host)
            yield Record(pfx + 'ALL', '', '1')
            if found:
                yield Record(pfx + 'SX', '', '1')
                for host in found:
                    yield Record(pfx + host, '', '1')
    except (NameError, AttributeError, TypeError):
        raise
    except Exception:
        pass

def cleankey(rec):
    _, k = rec.key.split('\t', 1)
    yield Record(k, '', rec.value)

if __name__ == '__main__':
    main()

