#!/usr/bin/env python2

from mapreducelib import Record, MapReduce as MR
from logparse import parseReqans
from mymrutils import *
import random
from collections import defaultdict

def main():
    MR.useDefaults(username='snippets', server='cedar00.search.yandex.net:8013', verbose=True)
    DST = 'likhomanov/tophosts_2787_2'
    with mktmp() as tmp:
        for src in ['reqans_log/{}'.format(d) for d in strdaterange((2015,2,9), (2015,2,16))]:
            MR.runCombine(getData, srcTable=src, dstTable=tmp, appendMode=True)
            mrsort(tmp)
        MR.runReduce(Summarizer(), srcTable=tmp, dstTable=tmp)
        MR.runMap(presort, srcTable=tmp, dstTable=tmp)
        MR.runReduce(Limiter(1000), srcTable=tmp, dstTable=DST)

def getData(recs):
    d = defaultdict(int)
    for rec in recs:
        req, ress = parseReqans(rec.value)
        if not iswww(req):
            continue
        if serpLang(req) != 'ru':
            continue
        for res in ress:
            if 'snippets_type' not in res:
                continue
            d['ALL'] += 1
            d[getHost(res['url'])] += 1
            if len(d) > 100000:
                for k, v in d.iteritems():
                    yield Record(k, '', str(v))
                d = defaultdict(int)
    for k, v in d.iteritems():
        yield Record(k, '', str(v))

def presort(rec):
    n = int(rec.value)
    yield Record('0', str(100000000000000 - n), '{}\t{}'.format(n, rec.key))

if __name__ == '__main__':
    main()

