#!/usr/bin/env python2

from mapreducelib import Record, TemporaryTable, MapReduce as MR
from reqansparse import parseRARecord
from mymrutils import *
from itertools import islice
import re
from hashlib import md5
import random

serpRE = re.compile(r'https?://(www\.)?yandex\.([^/]*)/yandsearch')
hostRE = re.compile(r'https?://(www\.)?([^/]*)(/.*)?$')

foodhosts = set()
for l in open('turkishfoodsites'):
    l = l.strip()
    if l:
        foodhosts.add(l)

foodreqs = set()
for l in open('turkishfoodqueries'):
    l = l.strip()
    if l:
        foodreqs.add(l)

def main():
    MR.useDefaults(username='snippets', server='cedar00.search.yandex.net:8013', verbose=True, files=['turkishfoodsites', 'turkishfoodqueries'])
    mktmp = lambda: TemporaryTable(project='likhomanov')
    mrsort = lambda table: MR.sortTable(srcTable=table.name, dstTable=table.name)
    DST = 'likhomanov/turkfoodtophosts'
    with mktmp() as tmp:
        for src in ['reqans_log/201407{:02}'.format(i) for i in range(1,8)]:
            MR.runMap(getshows, srcTable=src, dstTable=tmp.name)
            MR.runReduce(Summarizer(), srcTable=tmp.name, dstTable=DST, appendMode=True)
        MR.runReduce(Summarizer(), srcTable=DST, dstTable=DST)
        MR.runMap(preSort, srcTable=DST, dstTable=DST)
        MR.sortTable(srcTable=DST, dstTable=DST)

def getshows(rec):
    ra = parseRARecord(rec.value)
    lang = serpLang(ra['request'].get('serp_url'))
    if lang != 'com.tr': #not in ('ru', 'ua', 'by', 'kz'):
        return
    if ra['request']['req'] not in foodreqs:
        return
    for i, res in enumerate(ra['results']):
        if i >= 10:
            return
        host = getHost(res.get('url'))
        if not host or host in foodhosts:
            continue
        yield Record(host, '', '1')

def preSort(rec):
    n = int(rec.value)
    yield Record('0', str(10000000 - n), '{}\t{}'.format(n, rec.key))

if __name__ == '__main__':
    main()

