#!/usr/bin/env python2

from mapreducelib import Record, TemporaryTable, MapReduce as MR
from reqansparse import parseRARecord
from itertools import islice
import re
from hashlib import md5
import random

serpRE = re.compile(r'https?://(www\.)?yandex\.([^/]*)/yandsearch')
needed = 100


def main():
    MR.useDefaults(username='snippets', server='cedar00:8013', verbose=True)
    mktmp = lambda: TemporaryTable(project='likhomanov')
    mrsort = lambda table: MR.sortTable(srcTable=table.name, dstTable=table.name)
    with mktmp() as tmp:
        for src in ['reqans_log/201405{:2}'.format(i) for i in (26,)]:
            MR.runMap(getreqs, srcTable=src, dstTable=tmp.name)
        mrsort(tmp)
        MR.runReduce(getNeeded, srcTable=tmp.name, dstTable='likhomanov/torrentreqstr')

def serpLang(url):
    if not url:
        return None
    m = re.match(serpRE, url)
    if not m:
        return None
    return m.group(2)

def getreqs(rec):
    ra = parseRARecord(rec.value)
    lang = serpLang(ra['request'].get('serp_url'))
    if lang != 'com.tr': #not in ('ru', 'ua', 'by', 'kz'):
        return
    havetor = False
    for res in ra['results']:
        stype = res.get('snippets_type')
        if stype != 'vertis':
            continue
        havetor = True
    if havetor:
        yield Record('0', str(random.random()), ra['request']['req'])

def getNeeded(key, recs):
    reqs = set()
    for rec in recs:
        r = rec.value
        if r not in reqs:
            reqs.add(r)
            yield Record('0', '', r)
            if len(reqs) >= needed:
                return

if __name__ == '__main__':
    main()

