#!/usr/bin/env python2

from mapreducelib import Record, TemporaryTable, MapReduce as MR
from reqansparse import parseRARecord
from mymrutils import *
from itertools import islice
import re
from hashlib import md5
import random

def main():
    MR.useDefaults(username='snippets', server='cedar00.search.yandex.net:8013', verbose=True)
    DST = 'likhomanov/turkforums_all'
    with mktmp() as tmp:
        for src in ['reqans_log/201407{:02}'.format(i) for i in range(14, 17)]:
            MR.runMap(getForums, srcTable=src, dstTable=tmp.name, appendMode=True)
        MR.runReduce(Limiter(1), srcTable=tmp.name, dstTable=DST)

def getForums(rec):
    ra = parseRARecord(rec.value)
    checkwww(ra)
    if serpLang(ra['request'].get('serp_url')) != 'com.tr':
        return
    for res in ra['results']:
        url = res.get('url')
        host = getHost(url)
        if not host:
            continue
        st = res.get('snippets_type')
        if st and 'forum' in st:
            yield Record(host, '', '')

if __name__ == '__main__':
    main()

