#!/usr/bin/env python2

from mapreducelib import Record, TemporaryTable, MapReduce as MR
from logparse import parseReqans
from mymrutils import *
from itertools import islice
from collections import defaultdict
import random

def main():
    MR.useDefaults(username='snippets', server='cedar00.search.yandex.net:8013', verbose=True)
    DST = 'likhomanov/video_sample'
    with mktmp() as tmp:
        for src in ['reqans_log/{}'.format(d) for d in strdaterange((2014, 8, 18), (2014, 8, 20))]:
            MR.runCombine(getvideo, srcTable=src, dstTable=tmp, appendMode=True)
        MR.runReduce(Limiter(100), srcTable=tmp, dstTable=DST)

def getvideo(recs):
    for rec in recs:
        req, ress = parseReqans(rec.value)
        if req.get('stype') != 'www':
            continue
        if req.get('is_yandex', '0') == '1':
            continue
        lang = serpLang(req)
        if lang not in ('ru', 'ua', 'by', 'kz', 'com.tr'):
            continue
        for res in ress:
            stype = res.get('snippets_type')
            if not stype:
                continue
            if not stype.startswith('video'):
                continue
            if random.random() < 0.01:
                yield Record(stype, str(random.random()), '{}\t{}'.format(req['req'], res['url']))

if __name__ == '__main__':
    main()

