#!/usr/bin/env python2

from mapreducelib import Record, MapReduce as MR
from logparse import parseReqans
from mymrutils import *
from hashlib import md5
import random

def main():
    MR.useDefaults(username='snippets', server='cedar00.search.yandex.net:8013', verbose=True)
    DST = 'likhomanov/ruwiki'
    with mktmp() as tmp:
        for src in ['reqans_log/{}'.format(d) for d in strdaterange((2015, 2, 25), (2015, 2, 28))]:
            MR.runCombine(getData, srcTable=src, dstTable=tmp, appendMode=True)
        MR.runReduce(Limiter(1), srcTable=tmp, dstTable=DST)

def getData(recs):
    for rec in recs:
        req, ress = parseReqans(rec.value)
        if not iswww(req):
            continue
        if serpLang(req) != 'ru':
            continue
        for res in ress:
            if 'snippets_type' not in res:
                continue
            if getHost(res['url']) == 'ru.wikipedia.org':
                yield Record(md5(req['req']).hexdigest(), str(random.random()), req['req'] + '\t' + res['url'])

if __name__ == '__main__':
    main()

