#!/usr/bin/env python2

from mapreducelib import Record, TemporaryTable, MapReduce as MR
from logparse import parseReqans
from mymrutils import *
from hashlib import md5
from itertools import groupby
from collections import defaultdict

rechosts = [l.split()[0] for l in open('xmlrechosts')]

def main():
    MR.useDefaults(username='snippets', server='cedar00.search.yandex.net:8013', verbose=True, files=['xmlrechosts'])
    DST = 'likhomanov/xml_rec_stat'
    with mktmp() as tmp:
        for src in ['reqans_log/{}'.format(d) for d in strdaterange((2014, 8, 4), (2014, 8, 11))]:
            MR.runCombine(getData, srcTable=src, dstTable=tmp, appendMode=True)
        MR.runReduce(Summarizer(), srcTable=tmp, dstTable=DST)

def getData(recs):
    stats = defaultdict(int)
    for rec in recs:
        req, ress = parseReqans(rec.value)
        if req.get('stype') != 'www':
            continue
        if req.get('is_yandex', '0') == '1':
            continue
        lang = serpLang(req)
        if lang not in ('ru', 'ua', 'by', 'kz'):
            continue
        for res in ress:
            stype = res.get('snippets_type')
            if not stype:
                continue
            stats[lang + ' ALL'] += 1
            if stype == 'recipe':
                stats[lang + ' REC'] += 1
                host = getHost(res.get('url'))
                if host in rechosts:
                    stats[lang + ' ' + host] += 1
    for k, v in stats.iteritems():
        yield Record(k, '', str(v))

if __name__ == '__main__':
    main()

