#!/usr/bin/env python2

from mapreducelib import Record, MapReduce as MR
from logparse import parseReqans
from mymrutils import *
from itertools import islice
import re
from hashlib import md5
import random
from collections import defaultdict

def main():
    MR.useDefaults(username='snippets', server='cedar00.search.yandex.net:8013', verbose=True)
    DST = 'likhomanov/yacatr_sample'
    with mktmp() as tmp:
        for src in ['reqans_log/{}'.format(d) for d in strdaterange((2014,10,20), (2014,10,27))]:
            MR.runCombine(getData, srcTable=src, dstTable=tmp, appendMode=True)
        MR.runReduce(summarize, srcTable=tmp, dstTable=tmp)
        MR.runReduce(Limiter(100), srcTable=tmp, dstTable=DST)

def getData(recs):
    for rec in recs:
        req, ress = parseReqans(rec.value)
        if req.get('stype') != 'www':
            continue
        if req.get('is_yandex', '0') == '1':
            continue
        if serpLang(req) != 'com.tr':
            continue
        for res in ress:
            if res.get('snippets_type') == 'yaca':
                yield Record(res['url'], '', '')

def summarize(key, recs):
    n = 0
    for _ in recs:
        n += 1
    yield Record('0', str(10000000 - n), '{}\t{}'.format(key, n))

if __name__ == '__main__':
    main()

