USE hahn;

PRAGMA AnsiInForEmptyOrNullableItemsCollections;

/*
Сейчас открутки клиентов рассчитываются от даты добавления
логина представителя в директе.
Чтобы изменить расчет только начиная с даты добавления логина представителя
в карточку CRM нужно использовать следующую дату вместо create_dt:
max(date_142_amo, min(`create_dt`)) as `create_dt`
 нужно раскомментить в $base строчку 48
*/

-- Клиенты Мелло, с которыми договорились, что они начали с марта
$change_month_03 =  (96293846,  96762215,  79296351, 97212471, 97404892) ;
$change_month_04 =  (97878993, 97548426) ;
-- Клиент лидс
$change_month_06 =  (2111796, ) ;
       
$diff = ($a,$b) -> {
    return (CAST(DateTime::GetMonth(CAST($a as DATE)) as INT) - 
            CAST(DateTime::GetMonth(CAST($b as DATE)) as INT)) + 
            12U * (
                DateTime::GetYear(CAST($a as DATE)) - 
                DateTime::GetYear(CAST($b as DATE))
            )
    };


$base = 


select 
    month,
    clientid,
    create_dt,
    agency_name,
    agency_real_name,
    email,
    sum(coalesce(cd.money_wo_discount, 0)) as money,
    count(distinct cd.day) as cnt_days,
    min(day) as min_day,
    last_day
from `//statbox/cube/daily/comdep/cd_reporting/cd_all_with_tiers` as cd
join `//home/geoadv/geosmb/analytics/amocrm/prod/logins` as logs
    on cd.clientid = logs.clientid
where  
    cd.money_wo_discount > 0 
    and cd.scale = 'days'
    and cd.currency = 'rur'
    and cd.product = 'Общая выручка'
    and cd.product_1 like 'Директ%'
    and logs.login_from_amo = logs.login
    and cd.day >= logs.date_142_amo
    -- and cd.day >= logs.date_142_amo
    and cd.day <= logs.last_day 
group by 
    cd.clientid as clientid, 
    logs.agency_name as agency_name,
    logs.agency_real_name as agency_real_name,
    logs.email as email,
    logs.date_142_amo as create_dt,
    substring(cd.day,0,7)||'-01' as month,
    logs.last_day as last_day
;


INSERT INTO `//home/geoadv/geosmb/analytics/amocrm/prod/money_login` WITH TRUNCATE 

SELECT 
    a.*,
    month_num*2+8 as proc_prize,
    case 
        when month_num = 0 then 1
        when money >= 10000 then 1
        ELSE 0
    END as fix_pay_flg

FROM 
(
    SELECT 
        a.*,
        
        case 
            when clientid in $change_month_03 then $diff(month,'2022-03-01')
            when clientid in $change_month_04 then $diff(month,'2022-04-01')
            when clientid in $change_month_06 then $diff(month, '2022-06-01')
            else $diff(month,min(min_day) over (partition by clientid)) 
        end as month_num
    from $base as a
) as a
