use hahn;

$domains_in_exp = 
SELECT 
    contacts.`client_id` as client_id,
    clients.`curr_client_main_domain` as domain,
    `curr_counterparty_id`,
    `created_at`,
    agency.`agency_name` as agency_name
from 
    `//home/geoadv/geosmb/analytics/amocrm/prod/all_contacts` as contacts
join 
    `//home/geoadv/geosmb/analytics/amocrm/prod/all_agency` as agency 
    on agency.responsible_user_id = contacts.responsible_user_id
left join 
    `//home/comdep-crm-advisor/prod/common/clients/latest` as clients 
    on contacts.client_id = cast(clients.client_id as string)
;


$money = 
SELECT 
    agency_name,
    clientid, 
    month, 
    `curr_client_main_domain`,
    `curr_counterparty_id`,
    sum(`money`) as `money`
from 
    `//statbox/cube/daily/comdep/cd_reporting/cd_all_with_tiers` as cd
join 
    `//home/geoadv/geosmb/analytics/amocrm/prod/all_agency` as agency 
    using(agency_name)
where  
    cd.scale = 'months'
    and money > 0
    and month like '2022%'
    and cd.currency = 'rur'
    and cd.product = 'Общая выручка'
    and cd.product_1 like 'Директ%'
group by 
    cd.clientid as clientid, 
    cd.agency_name as agency_name,
    cd.month as month, 
    cd.`curr_client_main_domain` as curr_client_main_domain,
    cd.`curr_counterparty_id` as curr_counterparty_id
;

$res = 
SELECT 
    domains.*, 
    coalesce(domain_money.clientid, counterparty_money.clientid ) as clientid_new,
    coalesce(domain_money.month, counterparty_money.month) as month,
    coalesce(domain_money.money,counterparty_money.money) as money
from 
    $domains_in_exp as domains 
left join 
    $money as domain_money
    on domains.domain = domain_money.curr_client_main_domain 
    and domains.agency_name = domain_money.agency_name 
left join 
    $money as counterparty_money
    on domains.curr_counterparty_id = counterparty_money.curr_counterparty_id 
    and domains.agency_name = counterparty_money.agency_name ;


insert into `//home/geoadv/geosmb/analytics/amocrm/prod/clients_after_exp` WITH TRUNCATE 
select * from $res;

select * from $res where money is not null;

