USE hahn;
PRAGMA yt.InferSchema;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$format = DateTime::Format("%Y-%m-%d");
$log_clean = ($a) -> 
    {return String::ReplaceAll(String::SplitToList(String::AsciiToLower($a),'@')[0],'.','-')};

$today = cast(CurrentUtcDate() as string);

$logins = 
SELECT 
    $log_clean(a.login) as login,
    $format(DateTime::FromSeconds(cast(a.createtime as UInt32))) as create_dt,
    a.ClientID as clientid,
    $log_clean(b.login_for_agency) as login_from_amo,
    b.amo_contact_id as  amo_contact_id,
    b.name as name,
    agency.name as agency_name,
    agency.manager as manager,
    agency.agency_name as agency_real_name,
    agency.email as email,
    $today as last_day
FROM LIKE("//home/direct/mysql-sync/current","ppc:%", "straight/users") as a 

inner join  `//home/geoadv/geosmb/analytics/amocrm/prod/all_contacts` as b
    on a.ClientID = cast( b.client_id as int64)
join `//home/geoadv/geosmb/analytics/amocrm/prod/all_agency` as agency 
    on agency.responsible_user_id = b.responsible_user_id

WHERE 
    b.login_for_agency IS NOT NULL 
    and a.rep_type !='chief'
;


$amo = 
SELECT 
    min(dt) as  date_142,
    id_lead
from  
    `//home/geoadv/geosmb/analytics/amocrm/prod/all_leads` 
WHERE  
    status_id = 142 -- передан доступ представителя
group by
    id_lead
;

INSERT INTO `//home/geoadv/geosmb/analytics/amocrm/prod/logins` WITH TRUNCATE 
select 
    logins.*,
    amo.date_142 as date_142_amo,
    false as flg_deleted
from
    $logins as logins
left join 
    `//home/geoadv/geosmb/analytics/amocrm/prod/contact_id_amo` as comm 
    on comm.contact_id = logins.amo_contact_id
left join $amo as amo
    on amo.id_lead = comm.`lead_id`
left join
    `//home/geoadv/geosmb/analytics/amocrm/prod/logins` as all_logins
    on all_logins.login = logins.login
where 
    all_logins.flg_deleted != True
    or all_logins.flg_deleted is NULL

union all
select 
    all_logins.*,
    True as flg_deleted
    without all_logins.flg_deleted
from
    `//home/geoadv/geosmb/analytics/amocrm/prod/logins` as all_logins
left only join
    $logins as new_logins
    using(login)
;

$logins_added_new = 
select 
    logins.*,
    amo.date_142 as date_142_amo,
    $today as trigger_dt,
    without logins.last_day
from
    $logins as logins
left join 
    `//home/geoadv/geosmb/analytics/amocrm/prod/contact_id_amo` as comm 
    on comm.contact_id = logins.amo_contact_id
left join $amo as amo
    on amo.id_lead = comm.`lead_id`
left join
    `//home/geoadv/geosmb/analytics/amocrm/prod/logins` as all_logins
    on all_logins.login = logins.login
where 
    all_logins.flg_deleted = True
;

INSERT INTO `//home/geoadv/geosmb/analytics/amocrm/prod/logins_added_new`  WITH TRUNCATE 
SELECT *
from $logins_added_new
