use hahn;

select 
   a.responsible_user_id as id,
   a.cnt as cnt,
   a.wait_days as wait_days,
   c.priority as priority,
   c.critical as critic
from `//home/geoadv/geosmb/analytics/amocrm/prod/all_agency` as a
join `//home/geoadv/geosmb/analytics/amocrm/prod/agency_wiki` as b 
    on a.agency_name = b.Agency
join `//home/geoadv/geosmb/analytics/amocrm/prod/priority_agency` as c 
    on c.priority = cast(b.Priority as int32)
left join 
    `//home/geoadv/geosmb/analytics/amocrm/test/agency_capacity_wiki` as capacity
    on capacity.`agency_name` = b.Agency
where 
    a.agency_name != 'Sematica'
    and c.priority !=4
    and coalesce(cast(capacity.`max_clients` as int64), 300) > a.`cnt`;
