use hahn;
PRAGMA yt.InferSchema; PRAGMA yson.DisableStrict;

$list_adhoc = AsList(97719333, 97519939, 97525529, 97572580, 
    97689341, 94828699, 97442567, 97601720, 
    97669278, 97672571, 97676972, 97678954);
    
select a.* ,
    coalesce(client_name,client_login) as client_name,
    without a.client_name
from `//home/smbsales/h2s/2.0/transfer_h2s_client_to_agency` as a 
LEFT ONLY JOIN `//home/geoadv/geosmb/analytics/amocrm/prod/all_contacts` as b
    on a.client_id = cast(b.client_id as int64)
where 
   a.is_used =  '0' 
   and a.date_add_approved is not null
   and a.client_id != 96945339
   and a.client_phone is not null 
   and (a.client_phone like '+7%' 
   or a.client_phone like '8%')
   and a.client_id not in $list_adhoc
;

INSERT INTO `//home/geoadv/geosmb/analytics/amocrm/prod/broken_reqs` 

select a.* ,
    coalesce(client_name,client_login) as client_name,
    cast(CurrentUtcDate() as string) as dt,
    without a.client_name
from `//home/smbsales/h2s/2.0/transfer_h2s_client_to_agency` as a 
LEFT ONLY JOIN `//home/geoadv/geosmb/analytics/amocrm/prod/all_contacts` as b
    on a.client_id = cast(b.client_id as int64)
where 
   a.is_used =  '0' 
   and (a.client_phone is null 
   or (a.client_phone not like '+7%' 
        and a.client_phone not like '8%')
   )
