

use hahn;
PRAGMA yt.InferSchema;
PRAGMA  yson.DisableStrict;


$parse_date = ($dt) -> {
    RETURN DateTime::MakeDate(DateTime::Parse('%Y-%m-%d')($dt))};

$agency_speed = 
select 
    responsible_user_id,
    DateTime::ToDays( avg($parse_date(suc_dt) - $parse_date( coalesce(new_dt,not_new_dt))) ) as from_new_to_suc,
    DateTime::ToDays( avg($parse_date(not_new_dt) - $parse_date( coalesce(new_dt,not_new_dt))) ) as from_new_to_not_n,
    DateTime::ToDays( max($parse_date(not_new_dt) - $parse_date(coalesce(new_dt,not_new_dt))) ) as max_in_new
from( 
    SELECT 
        id_lead,responsible_user_id,
        min(if(status_id = 42065728,dt)) as new_dt,
        min(if(status_id != 42065728,dt)) as not_new_dt,
        min(if(status_id = 142,dt)) as suc_dt
    from `//home/geoadv/geosmb/analytics/amocrm/prod/all_leads`
    group by responsible_user_id, id_lead
)
group by responsible_user_id
;


$base = 
SELECT 
    space.client_id as client_id, 
    space.`client_name` as client_name,
    space.`date_add_approved` as date_add_approved,
    space.`date_agreed` as date_agreed,
    space.full_name as name_manager_call,
    space.manager_login as login_manager_call,
    space.group_name as group_manager_call,
    contacts.`created_at` as amo_put_dt,
    agency.name as agency_name, 
    leads.id_lead as id_lead,
    leads.status_id as current_status,
    agency.manager as manager,
    agency.agency_name as agency_real_name,
    contacts.responsible_user_id as responsible_user_id
from 
(   
    select 
       space.`client_name` as client_name,
        space.`date_add_approved` as date_add_approved,
        space.`date_agreed` as date_agreed,
        space.full_name as full_name,
        space.manager_login as manager_login,
        space.group_name as group_name,
        coalesce(change.new_clientid,space.client_id) as client_id,
    from `//home/smbsales/h2s/2.0/transfer_h2s_client_to_agency` as space
    left join `//home/geoadv/geosmb/analytics/amocrm/prod/change_id`  as change
        on change.old_id = space.client_id

    UNION ALL

    select 
        client_name,
        date_add_approved,
        date_agreed,
        full_name,
        manager_login,
        group_name,
        client_id
    from 
        `//home/geoadv/geosmb/analytics/amocrm/prod/manually_added_clients` 
) as space
join `//home/geoadv/geosmb/analytics/amocrm/prod/all_contacts` as contacts 
    on space.client_id = cast(contacts.client_id as int64)
join `//home/geoadv/geosmb/analytics/amocrm/prod/contact_id_amo` as comm 
    on comm.contact_id = contacts.amo_contact_id
join `//home/geoadv/geosmb/analytics/amocrm/prod/actual_leads` as leads 
    on leads.id_lead = comm.lead_id
join `//home/geoadv/geosmb/analytics/amocrm/prod/all_agency` as agency 
    on agency.responsible_user_id = contacts.responsible_user_id
;

$start_status = 
SELECT 
    id_lead,
    min(dt) as start_status_dt
from $base as b
join `//home/geoadv/geosmb/analytics/amocrm/prod/all_leads` as leads
    on b.id_lead =  leads.id_lead
where b.current_status = leads.status_id
group by b.id_lead as id_lead
;


INSERT INTO `//home/geoadv/geosmb/analytics/amocrm/prod/not_onboard` WITH TRUNCATE 

select  
    b.*,
    st.start_status_dt as start_status_dt,
    asp.from_new_to_suc as from_new_to_suc,
    asp.from_new_to_not_n as from_new_to_not_n,
    asp.max_in_new as max_in_new
from $base as b
join $start_status as st
    on b.id_lead = st.id_lead
join $agency_speed as asp 
    on asp.responsible_user_id = b.responsible_user_id
;
