use hahn;
PRAGMA yt.InferSchema;
PRAGMA  yson.DisableStrict;
DECLARE $responseStatusCode as int64;

$find_value = ($lst,$name)->
    { return Yson::ConvertToString(
                        Yson::ConvertToDict(
                        Yson::ConvertToList(
                        ListFilter(
                            $lst,
                            ($x) -> { RETURN Yson::ConvertToString($x['field_name']) = $name } 
                        )[0]['values']
                        )[0]
                    )['value'])
    };


$address1 = '//home/geoadv/geosmb/analytics/amocrm/prod/get_curr_contacts';



$actual_contacts = 
        SELECT  ListMap(
                    ListMap( 
                        Yson::ConvertToList( DictLookup(Yson::LookupDict(Yson::ParseJson(`responseBody`),"_embedded"),'contacts')),
                        ($x) -> { RETURN Yson::ConvertToDict($x) }
                    ),
                    ($y)->{return AsStruct(Yson::ConvertToInt64($y['responsible_user_id'] ) as responsible_user_id,
                            Yson::ConvertToInt64($y['id'] ) as amo_contact_id,
                            Yson::ConvertToInt64($y['created_at'] ) as created_at,
                            Yson::ConvertToString($y['name']) as name,
                            $find_value(
                                    ListMap(
                                        Yson::ConvertToList($y['custom_fields_values']),
                                        ($x) -> { RETURN Yson::ConvertToDict($x) }
                                    ), 'Логин представителя'
                            ) as login_for_agency,
                            $find_value(
                                    ListMap(
                                        Yson::ConvertToList($y['custom_fields_values']),
                                        ($x) -> { RETURN Yson::ConvertToDict($x) }
                                    ), 'Direct ID'
                            ) as client_id,
                
                    ) }
                ) as pairs
        from $address1
;

INSERT INTO `//home/geoadv/geosmb/analytics/amocrm/prod/all_contacts` with truncate
    select 
        a.*
    from (
        select responsible_user_id,name,client_id,amo_contact_id,login_for_agency,created_at
        from (select * from $actual_contacts flatten by pairs)
        flatten columns
    ) as a 
    join `//home/geoadv/geosmb/analytics/amocrm/prod/all_agency` as b  
        on a.responsible_user_id = b.responsible_user_id

