use hahn;
PRAGMA yt.InferSchema ='1';
PRAGMA  yson.DisableStrict;

$today = DateTime::Format("%Y-%m-%d")(CurrentUtcDate());

$address1 = '//home/geoadv/geosmb/analytics/amocrm/prod/get_curr_leads';

    $base = 
        SELECT
            ListMap(
                ListMap( 
                    Yson::ConvertToList( DictLookup(Yson::LookupDict(Yson::ParseJson(`responseBody`),"_embedded"),'leads')),
                    ($x) -> { RETURN Yson::ConvertToDict($x) }
                ),
                ($y)->{return AsStruct(Yson::ConvertToInt64($y['responsible_user_id'] ) as responsible_user_id,
                        Yson::ConvertToInt64($y['status_id'] ) as status_id,
                        Yson::ConvertToInt64($y['loss_reason_id']) as loss_reason_id,
                        Yson::ConvertToString($y['name']) as name,
                        Yson::ConvertToInt64($y['id']) as id_lead) }
            ) as pairs
        from $address1
    ;

$actual_leads = 
SELECT 
        a.*,
        agency.name as agency_name,
        agency.manager as manager,
        agency.agency_name as agency_real_name
    from (
        select responsible_user_id,name,id_lead,loss_reason_id,status_id,$today as dt
        from (select * from $base flatten by pairs)
        flatten columns
    ) as a 
    join `//home/geoadv/geosmb/analytics/amocrm/prod/all_agency` as agency 
    on agency.responsible_user_id = a.responsible_user_id
;

INSERT INTO `//home/geoadv/geosmb/analytics/amocrm/prod/all_leads` WITH TRUNCATE 

SELECT *
from `//home/geoadv/geosmb/analytics/amocrm/prod/all_leads`
where dt != $today

union all 
    select * from $actual_leads
;

INSERT INTO `//home/geoadv/geosmb/analytics/amocrm/prod/actual_leads` WITH TRUNCATE 
    select * from $actual_leads
   

