use hahn;
PRAGMA yt.InferSchema ='1';
PRAGMA  yson.DisableStrict;

DECLARE $prepared as int32;
DECLARE $planned as int32;
$today = DateTime::Format("%Y-%m-%d")(CurrentUtcDate());


DEFINE ACTION $hello() AS
     $base = 
        SELECT

            ListMap(
                ListMap( 
                Yson::ConvertToList(responseBody),
                    ($x) -> { RETURN Yson::ConvertToDict($x) }
                ),
                ($y)->{return AsStruct(
                                Yson::ConvertToInt64($y['contact_id'] ) as contact_id,
                                Yson::ConvertToInt64($y['id'] ) as lead_id
                                )       
                        }
            ) as pairs
        from `//home/geoadv/geosmb/analytics/amocrm/prod/new_contacts`
    ;

    $cnt_added = 
    SELECT
        ListLength(Yson::ConvertToList(responseBody))
    from `//home/geoadv/geosmb/analytics/amocrm/prod/new_contacts`
    ;

    INSERT INTO `//home/geoadv/geosmb/analytics/amocrm/prod/contact_id_amo`

        select contact_id,lead_id,
        $today as dt
        from (select * from $base flatten by pairs)
        flatten columns

        union all 

        select 
            contact_id,
            lead_id,
            create_date as dt
        from 
            `//home/geoadv/geosmb/analytics/amocrm/prod/manually_added_clients` 
        where 
            contact_id not in
            (select contact_id from `//home/geoadv/geosmb/analytics/amocrm/prod/contact_id_amo`)
    ; 

    INSERT INTO `//home/geoadv/geosmb/analytics/amocrm/prod/add_clients_by_days`

        select  
            unwrap(cast($cnt_added as int32)) as added,
            $prepared as prepared,
            $planned as planned,
            $today as dt 

END DEFINE;

DEFINE ACTION $bye() AS
    INSERT INTO `//home/geoadv/geosmb/analytics/amocrm/prod/add_clients_by_days`

        select  
            0 as added,
            $prepared as prepared,
            $planned as planned,
            $today as dt 
END DEFINE;


EVALUATE IF $prepared>0 
    do $hello()
    else do  $bye();
    
