use hahn;

INSERT INTO `//home/geoadv/geosmb/analytics/amocrm/prod/all_agency` WITH TRUNCATE 
select 
    a.*,
    coalesce(DateTime::ToDays(CurrentUtcDate() - DateTime::FromSeconds(cast(b.last_create_dt as Uint32))),
        a.wait_days+1) as wait_days,
    coalesce(b.cnt,a.cnt) as cnt
    without a.cnt,a.wait_days
from `//home/geoadv/geosmb/analytics/amocrm/prod/all_agency` as a
left join (
    SELECT 
        id,
        max(created_at) as last_create_dt,
        count(distinct amo_contact_id) as cnt
    from  `//home/geoadv/geosmb/analytics/amocrm/prod/all_contacts`
    group by responsible_user_id as id
) as b
on a.responsible_user_id = b.id
;


