USE hahn;
$read_path = "home/geo-analytics/serge-ssk/agency_metrics/agency_conversion_prepare_new";
$prof_agency_path = "home/balance/prod/bo/v_contract_apex_full";
$cd_all_tiers = "statbox/cube/daily/comdep/cd_reporting/cd_all_with_tiers";

-- Список агентств про
$agency_pro_list = SELECT
    AGGREGATE_LIST(DISTINCT agency_id) AS AgencyID
FROM $prof_agency_path
WHERE
    agency_id IS NOT NULL
    AND finish_dt >= "2021-12-01"
    AND (wsale_ag_prm_awrd_sc_tp == "Премиум 2020" OR wsale_ag_prm_awrd_sc_tp == "РМП РФ");

-- Список агентств база
$agency_base_list = SELECT
    AGGREGATE_LIST(DISTINCT agency_id) AS AgencyID
FROM $prof_agency_path
WHERE
    agency_id IS NOT NULL
    AND finish_dt >= "2021-12-01"
    AND (wsale_ag_prm_awrd_sc_tp == "Базовая 2015" OR wsale_ag_prm_awrd_sc_tp == "Базовая лайт");

-- Список агентств, которые явялются агрегаторами
$agency_agregators = SELECT [523581, 28047771, 2371403, 2124001, 67140973, 9830514, 1332316, 35786724, 32805081, 5946133, 1621799, 322057, 472729, 36002706];

$select_for_differentiation_clients_channel_and_industry = SELECT
    clientid AS client_id,
    agency_id,
    curr_industry AS industry,
    IF(operator_role == "client", "Прямой канал", IF(ListHas($agency_agregators, agency_id), "Агрегаторы", IF(ListHas($agency_pro_list, agency_id), "Агентский канал (про)", "Агентский канал (база)"))) AS TypeClient,
FROM $cd_all_tiers
WHERE
    ListHas(["agency", "client", "elama"], operator_role)
    AND (operator_role == "client" OR ListHas($agency_agregators, agency_id) OR ListHas($agency_pro_list, agency_id) OR ListHas($agency_base_list, agency_id));

-- Сопоставляем каждому клиенту его средний за год чек
$mean_budget_clients = SELECT
    clientid AS client_id,
    AVG(money) AS MeanTotalRevenue,
    CASE
        WHEN AVG(money) < 500 * 1000 THEN '20K-500K'
        WHEN (AVG(money) >= 500 * 1000) AND (AVG(money) < 1000 * 1000) THEN '500K-1M'
        ELSE '1M-50M'
    END as ClientSize,
FROM $cd_all_tiers
WHERE
    scale == "months"
    AND product == "Общая выручка"
    AND period LIKE '2021%'
    AND money IS NOT NULL
GROUP BY clientid;

$select_for_differentiation_clients = SELECT
    a.client_id AS client_id,
    a.industry AS industry,
    a.TypeClient AS TypeClient,
    b.ClientSize AS ClientSize,
FROM $select_for_differentiation_clients_channel_and_industry AS a 

JOIN

$mean_budget_clients AS b 

ON a.client_id == b.client_id
WHERE b.MeanTotalRevenue < 50 * 1000 * 1000 AND b.MeanTotalRevenue > 20 * 1000;

$select_for_finish = SELECT
    a.fielddate AS FieldDate,
    a.client_id AS client_id,
    a.all_clicks AS all_clicks,
    a.all_goal_clicks AS all_goal_clicks,
    a.camp_goal_clicks AS camp_goal_clicks,
    a.shows AS shows,
    a.campaign_is_auto_strategy AS campaign_is_auto_strategy,
    b.TypeClient AS TypeClient,
    b.ClientSize AS ClientSize,
    b.industry AS Industry,
FROM $read_path AS a 

JOIN

$select_for_differentiation_clients AS b 

ON a.client_id == b.client_id;

SELECT
    FieldDate AS FieldDate,
    TypeClient AS TypeClient,
    ClientSize AS ClientSize,
    Industry AS Industry,
    SUM(camp_goal_clicks) as campaign_goal_clicks,
    Math::Round(100.0 * SUM(camp_goal_clicks) / SUM(shows), -4) as conv_camp_goals,
FROM $select_for_finish
WHERE NOT campaign_is_auto_strategy
GROUP BY TypeClient, ClientSize, Industry, FieldDate
ORDER BY FieldDate, TypeClient, ClientSize, Industry;
