USE hahn;
$read_path = "home/geo-analytics/serge-ssk/agency_metrics/agency_conversion_prepare";
-- $prof_agency_path = "home/search-research/yateika/rewards/ga-247/report";
$prof_agency_path = "home/balance/prod/bo/v_contract_apex_full";
$write_path = "home/geo-analytics/serge-ssk/agency_metrics/agency_conversion_show_goal_action_year_month";

-- Список агентств про
$agency_pro_list = SELECT
    AGGREGATE_LIST(DISTINCT agency_id) AS AgencyID
FROM $prof_agency_path
WHERE
    agency_id IS NOT NULL
    AND finish_dt >= "2021-12-01"
    AND (wsale_ag_prm_awrd_sc_tp == "Премиум 2020" OR wsale_ag_prm_awrd_sc_tp == "РМП РФ");

-- Список агентств, которые явялются агрегаторами
$agency_agregators = SELECT [523581, 28047771, 2371403, 2124001, 67140973, 9830514, 1332316, 35786724, 32805081, 5946133, 1621799, 322057, 472729, 36002706];

$select_for_finish_aux = SELECT
    fielddate AS FieldDate,
    agency_id AS AgencyID,
    client_id AS ClientID,
    CASE operator_role
        WHEN "elama" THEN "Агентский канал"
        WHEN "agency" THEN "Агентский канал"
        ELSE "Прямой канал"
    END AS TypeClient,
    CASE
        WHEN total_revenue < 500 * 1000 THEN 'до 500.000'
        WHEN total_revenue < 1000 * 1000 THEN 'от 500.000 до 1.000.000'
        ELSE 'от 1.000.000'
    END as ClientSize,
    clicks_on_goal AS clicks_on_goal,
    goal_shows AS goal_shows,
FROM $read_path;

$select_for_finish = SELECT
    FieldDate AS FieldDate,
    ClientID AS ClientID,
    IF(TypeClient == "Прямой канал", "Прямой канал", IF(ListHas($agency_agregators, AgencyID), "Агрегаторы", IF(ListHas($agency_pro_list, AgencyID), "Агентский канал (про)", "Агентский канал (база)"))) AS TypeClient,
    ClientSize AS ClientSize,
    clicks_on_goal,
    goal_shows,
FROM $select_for_finish_aux;

$select_finish_finish = SELECT
    FieldDate AS FieldDate,
    COUNT(DISTINCT ClientID) AS CountClient,
    TypeClient AS TypeClient,
    ClientSize AS ClientSize,
    CAST(SUM(clicks_on_goal) AS Double) AS sum_clicks_on_goal,
    CAST(SUM(goal_shows) AS Double) AS sum_goal_shows,
FROM $select_for_finish
GROUP BY FieldDate, ClientSize, TypeClient;

$select_month_finish = SELECT
    FieldDate AS FieldDate,
    CountClient AS CountClient,
    TypeClient AS TypeClient,
    ClientSize AS ClientSize,
    Math::Round(100 * sum_clicks_on_goal / sum_goal_shows, -2) AS Conversion,
    Math::Round(100 * Math::Sqrt(sum_clicks_on_goal) / sum_goal_shows, -6) AS ConversionStd,
    Math::Round(100 * Math::Sqrt(sum_clicks_on_goal) / sum_clicks_on_goal, -4) AS RelativeErrorConversion,
    CAST(sum_clicks_on_goal AS Double) AS sum_clicks_on_goal,
    CAST(sum_goal_shows AS Double) AS sum_goal_shows,
FROM $select_finish_finish;

$select_year = SELECT
    '2021' AS FieldDate,
    SUM(CountClient) AS CountClient,
    ClientSize AS ClientSize,
    TypeClient AS TypeClient,
    Math::Round(100 * SUM(sum_clicks_on_goal) / SUM(sum_goal_shows), -2) AS Conversion,
    Math::Round(100 * Math::Sqrt(SUM(sum_clicks_on_goal)) / SUM(sum_goal_shows), -6) AS ConversionStd,
    Math::Round(100 * (Math::Sqrt(SUM(sum_clicks_on_goal))) / SUM(sum_clicks_on_goal), -4) AS RelativeErrorConversion,
FROM $select_month_finish
GROUP BY ClientSize, TypeClient;

INSERT INTO $write_path WITH TRUNCATE
SELECT
    a.FieldDate ?? b.FieldDate AS FieldDate,
    a.CountClient ?? b.CountClient AS CountClient,
    a.ClientSize ?? b.ClientSize AS ClientSize,
    a.TypeClient ?? b.TypeClient AS TypeClient,
    a.Conversion ?? b.Conversion AS Conversion,
    a.ConversionStd ?? b.ConversionStd AS ConversionStd,
    a.RelativeErrorConversion ?? b.RelativeErrorConversion AS RelativeErrorConversion
FROM $select_year AS a

FULL JOIN

$select_month_finish AS b

ON a.FieldDate == b.FieldDate;
