USE hahn;
$read_path_cd_all_with_tiers = "statbox/cube/daily/comdep/cd_reporting/cd_all_with_tiers";
$read_path_product_money_extended_by_acts = "statbox/cube/daily/agency_rewards/product_money_extended_by_acts";
$write_path = "home/geo-analytics/serge-ssk/agency_metrics/agency_conversion_prepare";

$select_agency_client_money = SELECT
    period,
    clientid,
    operator_role,
    operator_login,
    agency_id,
    agency_name,
    agency_type,
    agency_type_crm,
    curr_agency_tier,
    SUM(money) as money
FROM $read_path_cd_all_with_tiers
WHERE
    scale == 'months'
    AND product == 'Общая выручка'
    AND currency == 'rur'
    AND period like '2021-%'
    AND ListHas(["agency", "client", "elama"], operator_role)
GROUP BY
    period,
    clientid,
    operator_role,
    operator_login,
    agency_id,
    agency_name,
    agency_type,
    agency_type_crm,
    curr_agency_tier;

$get_date = ($ts) -> {
    RETURN DateTime::Format('%Y-%m-%d')(DateTime::MakeDate(DateTime::FromSeconds(CAST($ts as UInt32))))
};

$select_agency_quality_dataset_partial = SELECT 
    event_date,
    client_id,
    cid,
    campaign_type,
    campaign_is_auto_strategy,
    has_goals_in_campaign,
    has_goals_in_click,
    SUM(shows) AS shows,
    SUM(clicks) AS clicks,
    SUM(revenue) AS revenue
FROM
    RANGE($read_path_product_money_extended_by_acts, '2021-01-01', '2021-12-01')
GROUP BY
    $get_date(eventtime) AS event_date,
    client_id,
    cid,
    campaign_type,
    campaign_is_auto_strategy,
    IF(campaign_meaningful_goals IS NULL OR ListLength(campaign_meaningful_goals) == 0, 'no goals in campaign', 'any goals in campaign') AS has_goals_in_campaign,
    IF(click_meaningful_goals IS NULL OR ListLength(click_meaningful_goals) == 0, 'no goals in click', 'any goals in click') AS has_goals_in_click;

$round_to_month = ($d) -> {
    $parser = DateTime::Parse('%Y-%m-%d');
    $formatter = DateTime::Format('%Y-%m-%d');
    RETURN $formatter(DateTime::MakeDate(DateTime::StartOfMonth($parser($d))))
};

$aux_select = SELECT
    fielddate,
    client_id,
    sum(revenue) AS total_revenue,
    sumIf(revenue, has_goals_in_campaign <> 'no goals in campaign') AS pm_revenue_in_campaigns_with_goals,
    sumIf(clicks, has_goals_in_campaign <> 'no goals in campaign' AND has_goals_in_click <> 'no goals in click') AS clicks_on_goal,
    -- считаем показы рекламы, у которой указаны цели
    sumIf(shows, has_goals_in_campaign <> 'no goals in campaign') AS goal_shows,
    sum(shows) AS total_shows,
    sum(clicks) AS total_clicks,
    sumIf(clicks, has_goals_in_campaign <> 'no goals in campaign') AS clicks_of_campaign_with_goal
FROM $select_agency_quality_dataset_partial
WHERE
    NOT campaign_is_auto_strategy 
    AND campaign_type LIKE 'text'
    GROUP BY $round_to_month(event_date) AS fielddate, client_id;

$select_agency_quality_dataset = SELECT
    *
FROM $select_agency_client_money AS cd

JOIN

$aux_select AS pm

ON CAST(cd.clientid as Int64) == CAST(pm.client_id as Int64) AND cd.period == pm.fielddate;

INSERT INTO $write_path WITH TRUNCATE
SELECT
    *
FROM $select_agency_quality_dataset
ORDER BY fielddate, client_id;
