USE hahn;
$read_path_product_money_extended_by_acts = "statbox/cube/daily/agency_rewards/product_money_extended_by_acts";
$write_path = "home/geo-analytics/serge-ssk/agency_metrics/agency_conversion_prepare_new";

$get_campaign_click_goals = ($r) -> {
    RETURN ListFilter($r.click_meaningful_goals ?? AsList(), ($item) -> {RETURN ListHas($r.campaign_meaningful_goals, $item.id)});
};

$get_date = ($ts) -> {
    RETURN DateTime::Format('%Y-%m-%d')(DateTime::MakeDate(DateTime::FromSeconds(CAST($ts as UInt32))))
};

$round_to_month = ($d) -> {
    $parser = DateTime::Parse('%Y-%m-%d');
    $formatter = DateTime::Format('%Y-%m-%d');
    RETURN $formatter(DateTime::MakeDate(DateTime::StartOfMonth($parser($d))))
};

$prepare_select = SELECT
    $round_to_month($get_date(eventtime)) AS fielddate,
    cid,
    client_id,
    agency_id,
    campaign_meaningful_goals ?? AsList() AS campaign_meaningful_goals,
    click_meaningful_goals,
    shows,
    clicks,
    campaign_is_auto_strategy,
    $get_campaign_click_goals(TableRow()) AS campaing_meaningful_goals_click
FROM RANGE($read_path_product_money_extended_by_acts, '2021-01-01', '2021-12-01');

INSERT INTO $write_path WITH TRUNCATE 
SELECT
    fielddate,
    cid,
    client_id,
    agency_id,
    campaign_meaningful_goals,
    campaign_is_auto_strategy,
    click_meaningful_goals,
    campaing_meaningful_goals_click,
    SUM(shows) as shows,
    SUM(clicks) as all_clicks,
    SUM_IF(clicks, ListHasItems(campaing_meaningful_goals_click)) as camp_goal_clicks,
    SUM_IF(clicks, ListHasItems(click_meaningful_goals)) as all_goal_clicks
FROM $prepare_select
GROUP BY
    fielddate,
    cid,
    client_id,
    agency_id,
    campaign_meaningful_goals,
    campaign_is_auto_strategy,
    click_meaningful_goals,
    campaing_meaningful_goals_click;
