USE hahn;
$read_path = "statbox/cube/daily/comdep/cd_reporting/cd_all_with_tiers";
$prof_agency_path_new = "home/balance/prod/bo/v_contract_apex_full";
$write_path = "//home/geo-analytics/serge-ssk/agency_metrics/agency_metrics_retention";

$diff = ($a,$b) -> {
    return (CAST(DateTime::GetMonth(CAST($a as DATE)) as INT) - 
            CAST(DateTime::GetMonth(CAST($b as DATE)) as INT)) + 
            12U * (
                DateTime::GetYear(CAST($a as DATE)) - 
                DateTime::GetYear(CAST($b as DATE))
            )
    };


-- Список агентств про
$agency_pro_list = SELECT
    AGGREGATE_LIST(DISTINCT agency_id) AS AgencyID
FROM $prof_agency_path_new
WHERE
    agency_id IS NOT NULL
    AND finish_dt >= "2021-12-01"
    AND (wsale_ag_prm_awrd_sc_tp == "Премиум 2020" OR wsale_ag_prm_awrd_sc_tp == "РМП РФ");

-- Список агентств, которые явялются агрегаторами
$agency_agregators = SELECT [523581, 28047771, 2371403, 2124001, 67140973, 9830514, 1332316, 35786724, 32805081, 5946133, 1621799, 322057, 472729, 36002706];


-- Сопоставляем каждому клиенту его средний за год чек и первый месяц
$mean_budget_clients = SELECT
    clientid,
    AVG(money) AS mean_total_revenue,
    min(month) AS Min_month
FROM $read_path
WHERE
    scale == "months"
    AND product == "Общая выручка"
    AND (period LIKE '2021%' or period LIKE '2020%')
    AND currency = 'rur'
    AND money is not null
GROUP BY 
    clientid;

$select_prepare =  SELECT
    a.period AS FieldDate,
    a.agency_id AS AgencyID,
    a.clientid AS ClientID,
    a.money AS TotalRevenue,
    a.operator_role AS operator_role,
    Min_month,
    $diff(month, Min_month) as Epoch,
    b.mean_total_revenue AS MeanTotalRevenue
FROM 
    $read_path AS a
JOIN
    $mean_budget_clients AS b
    ON a.clientid == b.clientid
WHERE
    a.scale == "months"
    AND a.product == "Общая выручка"
    AND a.period LIKE '2021%'
    AND a.money IS NOT NULL
    AND a.currency = 'rur';

$select_for_finish_aux = SELECT
    select_prepare.*,
    CASE 
        WHEN ListHas($agency_agregators, AgencyID) THEN "Агрегаторы"
        WHEN ListHas($agency_pro_list, AgencyID) THEN "Агентский канал (про)"
        WHEN operator_role = 'agency' THEN "Агентский канал (база)"
        else "Прямой канал"
    end as TypeClient,
    CASE
        WHEN MeanTotalRevenue < 500 * 1000 THEN 'до 500.000'
        WHEN (MeanTotalRevenue >= 500 * 1000) AND (MeanTotalRevenue < 1000 * 1000) THEN 'от 500.000 до 1.000.000'
        ELSE 'от 1.000.000 до 50.000.000'
    END as ClientSize,
    without operator_role
FROM 
    $select_prepare as select_prepare
WHERE 
    MeanTotalRevenue < 50 * 1000 * 1000 
    AND MeanTotalRevenue > 1000;

$select_for_finish = SELECT
    FieldDate AS FieldDate,
    ClientID AS ClientID,
    TotalRevenue AS TotalRevenue,
    TypeClient,
    Min_month,
    Epoch,
    ClientSize AS ClientSize,
FROM $select_for_finish_aux;

-- INSERT INTO $write_path WITH TRUNCATE
$preresult = SELECT
    FieldDate AS FieldDate,
    AVG(TotalRevenue) AS MeanTotalRevenue,
    TypeClient,
    ClientSize,
    Min_month,
    Epoch,
    Count(distinct ClientID) AS Epoch_size
FROM 
    $select_for_finish
GROUP BY 
    FieldDate, 
    TypeClient, 
    ClientSize,
    Min_month,
    Epoch;

$epoch0 = SELECT 
    TypeClient, 
    ClientSize,
    Min_month,
    Epoch_size
FROM 
    $preresult
WHERE
    Epoch = 0;

INSERT INTO $write_path WITH TRUNCATE
SELECT 
    pre.*,
    e0.Epoch_size AS Epoch_size0
FROM $preresult AS pre
JOIN
    $epoch0 AS e0
    ON pre.TypeClient = e0.TypeClient AND pre.ClientSize = e0.ClientSize AND pre.Min_month = e0.Min_month;
