USE hahn;
$read_path = "statbox/cube/daily/comdep/cd_reporting/cd_all_with_tiers";
$prof_agency_path = "home/balance/prod/bo/v_contract_apex_full";
$write_path = "home/geo-analytics/serge-ssk/agency_metrics/autotargeting_share_budget";

-- Список агентств про
$agency_pro_list = SELECT
    AGGREGATE_LIST(DISTINCT agency_id) AS AgencyID
FROM $prof_agency_path
WHERE
    agency_id IS NOT NULL
    AND finish_dt >= "2021-12-01"
    AND (wsale_ag_prm_awrd_sc_tp == "Премиум 2020" OR wsale_ag_prm_awrd_sc_tp == "РМП РФ");

-- Список агентств база
$agency_base_list = SELECT
    AGGREGATE_LIST(DISTINCT agency_id) AS AgencyID
FROM $prof_agency_path
WHERE
    agency_id IS NOT NULL
    AND finish_dt >= "2021-12-01"
    AND (wsale_ag_prm_awrd_sc_tp == "Базовая 2015" OR wsale_ag_prm_awrd_sc_tp == "Базовая лайт");

-- Список агентств, которые явялются агрегаторами
$agency_agregators = SELECT [523581, 28047771, 2371403, 2124001, 67140973, 9830514, 1332316, 35786724, 32805081, 5946133, 1621799, 322057, 472729, 36002706];

-- Подготавливаем данные с помощью FLATTEN BY
$prepare_select = SELECT
    *
FROM $read_path
FLATTEN BY product_list
WHERE
    scale == "months"
    AND period LIKE '2021%'
    AND money IS NOT NULL
    AND ListHas(["agency", "client", "elama"], operator_role)
    AND (operator_role == "client" OR ListHas($agency_agregators, agency_id) OR ListHas($agency_pro_list, agency_id) OR ListHas($agency_base_list, agency_id));

-- Считаем общую выручку для каждого клиента
$total_revenue = SELECT
    period AS Month,
    clientid AS ClientID,
    agency_id AS AgencyID,
    SUM(money) AS Money,
    product_list AS ProductList,
    CASE operator_role
        WHEN "elama" THEN "Агентский канал"
        WHEN "agency" THEN "Агентский канал"
        ELSE "Прямой канал"
    END AS TypeClient,
FROM $prepare_select
WHERE
    scale == "months"
    AND period LIKE '2021%'
    AND product_list == "Общая выручка"
    AND money IS NOT NULL
GROUP BY period, product_list, operator_role, clientid, agency_id;

-- Считаем выручку по автостратегиям для каждого клиента
$autostrategy_revenue = SELECT
    period AS Month,
    clientid AS ClientID,
    agency_id AS AgencyID,
    SUM(money) AS Money,
    product_list AS ProductList,
    CASE operator_role
        WHEN "elama" THEN "Агентский канал"
        WHEN "agency" THEN "Агентский канал"
        ELSE "Прямой канал"
    END AS TypeClient,
FROM $prepare_select
WHERE
    scale == "months"
    AND period LIKE '2021%'
    AND product_list == "Автотаргетинг"
    AND money IS NOT NULL
GROUP BY period, product_list, operator_role, clientid, agency_id;

-- Делим клиентов по бюджету и агентства на базу и про для общей выручки
$total_revenue_budget = SELECT
    Month AS Month,
    ClientID AS ClientID,
    IF(TypeClient == "Прямой канал", "Прямой канал", IF(ListHas($agency_agregators, AgencyID), "Агрегаторы", IF(ListHas($agency_pro_list, AgencyID), "Агентский канал (про)", "Агентский канал (база)"))) AS TypeClient,
    Money AS Money,
    CASE
        WHEN Money < 500 * 1000 THEN "20K-500K"
        WHEN Money >= 500 * 1000 AND Money < 1000 * 1000 THEN "500K-1M"
        ELSE "1M-50M"
    END AS ClientTierBudget,
FROM $total_revenue
WHERE Money < 50 * 1000 * 1000 AND Money > 20 * 1000;

-- Делим клиентов по бюджету
$total_revenue_budget_channel = SELECT
    Month AS Month,
    ClientID AS ClientID,
    TypeClient AS Channel,
    Money AS Money,
    CASE
        WHEN Money < 500 * 1000 THEN "20K-500K"
        WHEN Money >= 500 * 1000 AND Money < 1000 * 1000 THEN "500K-1M"
        ELSE "1M-50M"
    END AS ClientTierBudget,
FROM $total_revenue
WHERE Money < 50 * 1000 * 1000 AND Money > 20 * 1000;

-- Делим клиентов по бюджету и агентства на базу и про для выручки по автостратегиям
$autostrategy_revenue_budget = SELECT
    a.Month AS Month,
    a.ClientID AS ClientID,
    b.TypeClient AS TypeClient,
    a.Money AS Money,
    b.ClientTierBudget AS ClientTierBudget,
FROM $autostrategy_revenue AS a

INNER JOIN

$total_revenue_budget AS b

ON a.Month == b.Month AND a.ClientID == b.ClientID;

-- Делим клиентов по бюджету для выручки по автостратегиям
$autostrategy_revenue_budget_channel = SELECT
    a.Month AS Month,
    a.ClientID AS ClientID,
    b.Channel AS Channel,
    a.Money AS Money,
    b.ClientTierBudget AS ClientTierBudget,
FROM $autostrategy_revenue AS a

INNER JOIN

$total_revenue_budget_channel AS b

ON a.Month == b.Month AND a.ClientID == b.ClientID;

$select_for_total_revenue = SELECT
    Month AS Month,
    COUNT(DISTINCT ClientID) AS CountClientsBudget,
    TypeClient AS TypeClient,
    SUM(Money) AS Money,
    ClientTierBudget AS ClientTierBudget,
FROM $total_revenue_budget
GROUP BY Month, TypeClient, ClientTierBudget;

$select_for_total_revenue_channel = SELECT
    Month AS Month,
    COUNT(DISTINCT ClientID) AS CountClientsBudget,
    Channel AS Channel,
    SUM(Money) AS Money,
    ClientTierBudget AS ClientTierBudget,
FROM $total_revenue_budget_channel
GROUP BY Month, Channel, ClientTierBudget;

$select_for_autostrategy_revenue = SELECT
    Month AS Month,
    TypeClient AS TypeClient,
    SUM(Money) AS Money,
    ClientTierBudget AS ClientTierBudget,
FROM $autostrategy_revenue_budget
GROUP BY Month, TypeClient, ClientTierBudget;

$select_for_autostrategy_revenue_channel = SELECT
    Month AS Month,
    Channel AS Channel,
    SUM(Money) AS Money,
    ClientTierBudget AS ClientTierBudget,
FROM $autostrategy_revenue_budget_channel
GROUP BY Month, Channel, ClientTierBudget;

$select_finish_for_share_autostrategy = SELECT
    a.Month AS Month,
    a.TypeClient AS TypeClient,
    a.ClientTierBudget AS ClientTierBudget,
    b.Money / a.Money AS AutoStrategyShare,
    a.CountClientsBudget AS CountClientsBudget
FROM $select_for_total_revenue AS a

INNER JOIN

$select_for_autostrategy_revenue AS b

ON a.Month == b.Month AND a.TypeClient == b.TypeClient AND a.ClientTierBudget == b.ClientTierBudget;

$select_finish_for_share_autostrategy_channel = SELECT
    a.Month AS Month,
    a.Channel AS Channel,
    a.ClientTierBudget AS ClientTierBudget,
    b.Money / a.Money AS AutoStrategyShare,
    a.CountClientsBudget AS CountClientsBudget
FROM $select_for_total_revenue_channel AS a

INNER JOIN

$select_for_autostrategy_revenue_channel AS b

ON a.Month == b.Month AND a.Channel == b.Channel AND a.ClientTierBudget == b.ClientTierBudget;

INSERT INTO $write_path WITH TRUNCATE
SELECT
    a.Month ?? b.Month AS Month,
    a.TypeClient ?? b.Channel AS TypeClient,
    a.ClientTierBudget ?? b.ClientTierBudget AS ClientTierBudget,
    a.AutoStrategyShare ?? b.AutoStrategyShare As AutoStrategyShare,
    a.CountClientsBudget ?? b.CountClientsBudget AS CountClientsBudget,
FROM $select_finish_for_share_autostrategy AS a

FULL JOIN

$select_finish_for_share_autostrategy_channel AS b

ON a.Month == b.Month AND a.TypeClient == b.Channel AND a.ClientTierBudget == b.ClientTierBudget
ORDER BY Month, TypeClient, ClientTierBudget;
