USE hahn;
$read_path = "home/geo-analytics/serge-ssk/agency_metrics/agency_conversion_prepare";
-- $prof_agency_path = "home/search-research/yateika/rewards/ga-247/report";
$prof_agency_path = "home/balance/prod/bo/v_contract_apex_full";
$write_path = "home/geo-analytics/serge-ssk/agency_metrics/bootstrap_agency_conversion_equal_count_clients";
-- $write_path = "home/geo-analytics/serge-ssk/agency_metrics/agency_conversion_show_goal_action_year_month";

-- Список агентств про
$agency_pro_list = SELECT
    AGGREGATE_LIST(DISTINCT agency_id) AS AgencyID
FROM $prof_agency_path
WHERE
    agency_id IS NOT NULL
    AND finish_dt >= "2021-12-01"
    AND (wsale_ag_prm_awrd_sc_tp == "Премиум 2020" OR wsale_ag_prm_awrd_sc_tp == "РМП РФ");

-- Список агентств, которые явялются агрегаторами
$agency_agregators = SELECT [523581, 28047771, 2371403, 2124001, 67140973, 9830514, 1332316, 35786724, 32805081, 5946133, 1621799, 322057, 472729, 36002706];

$select_for_finish_aux = SELECT
    fielddate AS FieldDate,
    agency_id AS AgencyID,
    client_id AS ClientID,
    CASE operator_role
        WHEN "elama" THEN "Агентский канал"
        WHEN "agency" THEN "Агентский канал"
        ELSE "Прямой канал"
    END AS TypeClient,
    CASE
        WHEN total_revenue < 500 * 1000 THEN 'до 500.000'
        WHEN total_revenue < 1000 * 1000 THEN 'от 500.000 до 1.000.000'
        ELSE 'от 1.000.000'
    END as ClientSize,
    clicks_on_goal AS clicks_on_goal,
    goal_shows AS goal_shows,
FROM $read_path;

$select_for_finish = SELECT
    FieldDate AS FieldDate,
    ClientID AS ClientID,
    IF(TypeClient == "Прямой канал", "Прямой канал", IF(ListHas($agency_agregators, AgencyID), "Агрегаторы", IF(ListHas($agency_pro_list, AgencyID), "Агентский канал (про)", "Агентский канал (база)"))) AS TypeClient,
    ClientSize AS ClientSize,
    clicks_on_goal,
    goal_shows,
FROM $select_for_finish_aux
WHERE ClientSize == 'от 1.000.000';

$count_clients_straight = SELECT
    COUNT(DISTINCT ClientID) AS CountClients
FROM $select_for_finish
WHERE TypeClient == "Прямой канал";

$count_clients_agency_pro = SELECT
    COUNT(DISTINCT ClientID) AS CountClients
FROM $select_for_finish
WHERE TypeClient == "Агентский канал (про)";

$aux_select_for_count_clients = SELECT
    a.CountClients AS CountClientsStraight,
    b.CountClients AS CountClientsAgencyPro
FROM $count_clients_straight AS a

CROSS JOIN

$count_clients_agency_pro AS b;


$select_for_stochastic_straight = SELECT
    FieldDate AS FieldDate,
    ClientID AS ClientID,
    TypeClient AS TypeClient,
    ClientSize AS ClientSize,
    clicks_on_goal AS clicks_on_goal,
    goal_shows AS goal_shows
FROM $select_for_finish
WHERE TypeClient == "Прямой канал";

$select_for_stochastic_agency_pro = SELECT
    FieldDate AS FieldDate,
    ClientID AS ClientID,
    TypeClient AS TypeClient,
    ClientSize AS ClientSize,
    clicks_on_goal AS clicks_on_goal,
    goal_shows AS goal_shows
FROM $select_for_finish
WHERE TypeClient == "Агентский канал (про)";

$sub_select_stochastic = SELECT
    ListFromRange(1, 11) AS Stochastic;

$sub_select_samples = SELECT
    ListFromRange(1, 11) AS Samples;

$select_stochastic_straight = SELECT
    b.Stochastic AS Stochastic,
    a.FieldDate AS FieldDate,
    a.ClientID AS ClientID,
    a.TypeClient AS TypeClient,
    a.clicks_on_goal AS clicks_on_goal,
    a.goal_shows AS goal_shows
FROM $select_for_stochastic_straight AS a

CROSS JOIN

$sub_select_stochastic AS b
FLATTEN BY b.Stochastic;

$select_stochastic_agency_pro = SELECT
    b.Stochastic AS Stochastic,
    a.FieldDate AS FieldDate,
    a.ClientID AS ClientID,
    a.TypeClient AS TypeClient,
    a.clicks_on_goal AS clicks_on_goal,
    a.goal_shows AS goal_shows
FROM $select_for_stochastic_agency_pro AS a

CROSS JOIN

$sub_select_stochastic AS b
FLATTEN BY b.Stochastic;



$select_samples_straight = SELECT
    b.Samples AS Samples,
    a.Stochastic AS Stochastic,
    a.FieldDate AS FieldDate,
    a.ClientID AS ClientID,
    a.TypeClient AS TypeClient,
    a.clicks_on_goal AS clicks_on_goal,
    a.goal_shows AS goal_shows
FROM $select_stochastic_straight AS a

CROSS JOIN

$sub_select_samples AS b
FLATTEN BY b.Samples;

$aux_select_samples_agency_pro = SELECT
    b.Samples AS Samples,
    a.Stochastic AS Stochastic,
    a.FieldDate AS FieldDate,
    a.ClientID AS ClientID,
    a.TypeClient AS TypeClient,
    a.clicks_on_goal AS clicks_on_goal,
    a.goal_shows AS goal_shows
FROM $select_stochastic_agency_pro AS a

CROSS JOIN

$sub_select_samples AS b
FLATTEN BY b.Samples;

$select_samples_agency_pro = SELECT
    b.CountClientsStraight AS CountClientsStraight,
    b.CountClientsAgencyPro AS CountClientsAgencyPro,
    a.Samples AS Samples,
    a.Stochastic AS Stochastic,
    a.FieldDate AS FieldDate,
    a.ClientID AS ClientID,
    a.TypeClient AS TypeClient,
    a.clicks_on_goal AS clicks_on_goal,
    a.goal_shows AS goal_shows
FROM $aux_select_samples_agency_pro AS a

CROSS JOIN

$aux_select_for_count_clients AS b;



$select_stochastic_samples_straight = SELECT
    Samples AS Samples,
    ClientID AS ClientID,
    TypeClient AS TypeClient,
    clicks_on_goal AS clicks_on_goal,
    goal_shows AS goal_shows
FROM $select_samples_straight
TABLESAMPLE BERNOULLI(10.0);

SELECT 
    Samples AS Samples,
    ClientID AS ClientID,
    TypeClient AS TypeClient,
    clicks_on_goal AS clicks_on_goal,
    goal_shows AS goal_shows
FROM $select_stochastic_samples_straight;


$percent_for_agency_pro = SELECT 10.0 * CountClientsStraight / CountClientsAgencyPro FROM $aux_select_for_count_clients;

SELECT $percent_for_agency_pro;

$select_stochastic_samples_agency_pro = SELECT
    CountClientsStraight AS CountClientsStraight,
    CountClientsAgencyPro AS CountClientsAgencyPro,
    Samples AS Samples,
    ClientID AS ClientID,
    TypeClient AS TypeClient,
    clicks_on_goal AS clicks_on_goal,
    goal_shows AS goal_shows
FROM $select_samples_agency_pro
TABLESAMPLE BERNOULLI($percent_for_agency_pro);

SELECT 
    CountClientsStraight AS CountClientsStraight,
    CountClientsAgencyPro AS CountClientsAgencyPro,
    Samples AS Samples,
    ClientID AS ClientID,
    TypeClient AS TypeClient,
    clicks_on_goal AS clicks_on_goal,
    goal_shows AS goal_shows
FROM $select_stochastic_samples_agency_pro;

$select_conversion_straight = SELECT
    Samples AS Samples,
    TypeClient AS TypeClient,
    Math::Round(100 * CAST(SUM(clicks_on_goal) AS Double) / CAST(SUM(goal_shows) AS Double), -2) AS Conversion
FROM $select_stochastic_samples_straight
GROUP BY Samples, TypeClient;

$select_conversion_agency_pro = SELECT
    Samples AS Samples,
    TypeClient AS TypeClient,
    Math::Round(100 * CAST(SUM(clicks_on_goal) AS Double) / CAST(SUM(goal_shows) AS Double), -2) AS Conversion
FROM $select_stochastic_samples_agency_pro
GROUP BY Samples, TypeClient;

INSERT INTO $write_path WITH TRUNCATE
SELECT
    a.Samples ?? b.Samples AS Samples,
    a.TypeClient ?? b.TypeClient AS TypeClient,
    a.Conversion ?? b.Conversion AS Conversion,
FROM $select_conversion_straight AS a  

FULL JOIN 

$select_conversion_agency_pro AS b 
ON a.Samples == b.Samples AND a.TypeClient == b.TypeClient
ORDER BY Samples;
