USE hahn;
$read_path = "statbox/cube/daily/comdep/cd_reporting/cd_all_with_tiers";
-- $prof_agency_path = "home/search-research/yateika/rewards/ga-247/report";
$prof_agency_path = "home/balance/prod/bo/v_contract_apex_full";
$write_path = "home/geo-analytics/serge-ssk/agency_metrics/dynamic_agencies_budget_slice_all_months";

-- Список агентств про
$agency_pro_list = SELECT
    AGGREGATE_LIST(DISTINCT agency_id) AS AgencyID
FROM $prof_agency_path
WHERE
    agency_id IS NOT NULL
    AND finish_dt >= "2021-12-01"
    AND (wsale_ag_prm_awrd_sc_tp == "Премиум 2020" OR wsale_ag_prm_awrd_sc_tp == "РМП РФ");

-- Список агентств, которые явялются агрегаторами
$agency_agregators = SELECT [523581, 28047771, 2371403, 2124001, 67140973, 9830514, 1332316, 35786724, 32805081, 5946133, 1621799, 322057, 472729, 36002706];

-- Делаем для каждого клиента список месяцев, в которые он размещал рекламу
$clients_months = SELECT
    clientid AS ClientID,
    ListSort(AGGREGATE_LIST(DISTINCT period)) AS Months,
FROM $read_path
WHERE
    scale == "months"
    AND product == "Общая выручка"
    AND period LIKE '2021%'
    AND money IS NOT NULL
GROUP BY clientid;

-- Делаем срез по клиентам
$clients_slice = SELECT
    ListSort(AGGREGATE_LIST(DISTINCT ClientID)) AS ClientsID,
FROM $clients_months
WHERE Months == ["2021-01-01", "2021-02-01", "2021-03-01", "2021-04-01", "2021-05-01", "2021-06-01",
"2021-07-01", "2021-08-01", "2021-09-01", "2021-10-01", "2021-11-01", "2021-12-01"];

-- SELECT ClientsID FROM $clients_slice;

-- Сопоставляем каждому клиенту его средний за год чек
$mean_budget_clients = SELECT
    clientid AS clientid,
    AVG(money) AS mean_total_revenue
FROM $read_path
WHERE
    scale == "months"
    AND product == "Общая выручка"
    AND period LIKE '2021%'
    AND money IS NOT NULL
    AND ListHas($clients_slice, clientid)
GROUP BY clientid;

$select_prepare = SELECT
    a.period AS fielddate,
    a.agency_id AS agency_id,
    a.clientid AS client_id,
    a.money AS total_revenue,
    a.operator_role AS operator_role,
    b.mean_total_revenue AS MeanTotalRevenue
FROM $read_path AS a

JOIN

$mean_budget_clients AS b

ON a.clientid == b.clientid
WHERE
    a.scale == "months"
    AND a.product == "Общая выручка"
    AND a.period LIKE '2021%'
    AND a.money IS NOT NULL
    AND ListHas($clients_slice, a.clientid);

$select_for_finish_aux = SELECT
    fielddate AS FieldDate,
    agency_id AS AgencyID,
    client_id AS ClientID,
    total_revenue AS TotalRevenue,
    MeanTotalRevenue AS MeanTotalRevenue,
    CASE operator_role
        WHEN "elama" THEN "Агентский канал"
        WHEN "agency" THEN "Агентский канал"
        ELSE "Прямой канал"
    END AS TypeClient,
    CASE
        WHEN MeanTotalRevenue < 500 * 1000 THEN 'до 500.000'
        WHEN (MeanTotalRevenue >= 500 * 1000) AND (MeanTotalRevenue < 1000 * 1000) THEN 'от 500.000 до 1.000.000'
        ELSE 'от 1.000.000 до 50.000.000'
    END as ClientSize,
FROM $select_prepare
WHERE MeanTotalRevenue < 50 * 1000 * 1000 AND MeanTotalRevenue > 1000;

$select_for_finish = SELECT
    FieldDate AS FieldDate,
    ClientID AS ClientID,
    TotalRevenue AS TotalRevenue,
    IF(TypeClient == "Прямой канал", "Прямой канал", IF(ListHas($agency_agregators, AgencyID), "Агрегаторы", IF(ListHas($agency_pro_list, AgencyID), "Агентский канал (про)", "Агентский канал (база)"))) AS TypeClient,
    ClientSize AS ClientSize,
FROM $select_for_finish_aux;

INSERT INTO $write_path WITH TRUNCATE
SELECT
    FieldDate AS FieldDate,
    COUNT(DISTINCT ClientID) AS CountClients,
    AVG(TotalRevenue) AS MeanTotalRevenue,
    TypeClient AS TypeClient,
    ClientSize AS ClientSize,
FROM $select_for_finish
GROUP BY FieldDate, TypeClient, ClientSize;
