USE hahn;
$antifrod_flow_bases_table = "home/newsmb/serge-ssk/antifrod_flow_clients/antifrod_flow_clients_base_table";
$write_path = "home/newsmb/serge-ssk/antifrod_flow_clients/agency_to_agency_period_transmit_without_agregators";

$func_comp = ($time_transmit, $period_transmit_min, $period_transmit_max) -> {
    RETURN (($time_transmit <= $period_transmit_max) AND ($time_transmit >= $period_transmit_min));
};

-- Список агентств, которые явялются агрегаторами
$agency_agregators = SELECT [523581, 28047771, 2371403, 2124001, 67140973, 9830514, 1332316, 35786724, 32805081, 5946133, 1621799, 322057, 472729, 36002706];

$time_relaxation = SELECT
    client_domain,
    mean_total_revenue,
    agency_id_1,
    agency_name_1,
    agency_id_2,
    agency_name_2,
    client_id_1,
    counterparty_name_1,
    client_id_2,
    counterparty_name_2,
    min_period_1,
    max_period_1,
    min_period_2,
    max_period_2,
    min_period_2 AS date_flow,
    DateTime::ToDays(CAST(min_period_2 AS Date) - CAST(max_period_1 AS Date)) AS time_transmit,
FROM $antifrod_flow_bases_table
WHERE
    NOT ListHas($agency_agregators, agency_id_2);

INSERT INTO $write_path WITH TRUNCATE
SELECT 
    client_domain,
    mean_total_revenue,
    agency_id_1,
    agency_name_1,
    agency_id_2,
    agency_name_2,
    client_id_1,
    counterparty_name_1,
    client_id_2,
    counterparty_name_2,
    min_period_1,
    max_period_1,
    min_period_2,
    max_period_2,
    date_flow,
    DateTime::GetWeekOfYear(CAST(date_flow AS Date)) AS weeks,
    SUBSTRING(date_flow, 0, 7) AS year_and_month,
    time_transmit,
    CASE 
        WHEN $func_comp(time_transmit, 0, 0) THEN "0 - 0"
        WHEN $func_comp(time_transmit, 1, 5) THEN "1 - 5"
        WHEN $func_comp(time_transmit, 6, 10) THEN "6 - 10"
        WHEN $func_comp(time_transmit, 11, 15) THEN "11 - 15"
        WHEN $func_comp(time_transmit, -5, -1) THEN "-5 - -1"
        WHEN $func_comp(time_transmit, -10, -6) THEN "-10 - -6"
        WHEN $func_comp(time_transmit, -15, -11) THEN "-15 - -11"
        ELSE "other"
    END AS class_transmit_time,
FROM $time_relaxation
WHERE
    CASE 
        WHEN $func_comp(time_transmit, 0, 0) THEN "0 - 0"
        WHEN $func_comp(time_transmit, 1, 5) THEN "1 - 5"
        WHEN $func_comp(time_transmit, 6, 10) THEN "6 - 10"
        WHEN $func_comp(time_transmit, 11, 15) THEN "11 - 15"
        WHEN $func_comp(time_transmit, -5, -1) THEN "-5 - -1"
        WHEN $func_comp(time_transmit, -10, -6) THEN "-10 - -6"
        WHEN $func_comp(time_transmit, -15, -11) THEN "-15 - -11"
        ELSE "other" END != "other";
