USE hahn;
$cd_all_with_tiers = "statbox/cube/daily/comdep/cd_reporting/cd_all_with_tiers";
$write_path = "home/newsmb/serge-ssk/antifrod_flow_clients/antifrod_flow_clients_base_table";

-- Сопоставляем каждому клиенту его средний за год чек
$mean_budget_clients = SELECT
    curr_client_main_domain,
    SUM(money) / 12 AS mean_total_revenue,
FROM $cd_all_with_tiers
WHERE
    scale == "months"
    AND product == "Общая выручка"
    AND period LIKE '2021%'
    AND money IS NOT NULL
GROUP BY curr_client_main_domain;

$client_domains = SELECT
    COUNT(DISTINCT clientid) AS count_clients_id,
    DictKeys(ToSet(AGGREGATE_LIST(clientid))) AS clients_id_list,
    DictKeys(ToSet(AGGREGATE_LIST(agency_id))) AS agency_id_list,
    client_domain,
FROM $cd_all_with_tiers
WHERE
    operator_role == "agency"
    AND money IS NOT NULL
GROUP BY
    curr_client_main_domain AS client_domain
HAVING
    COUNT(DISTINCT clientid) == 2
    AND ListLength(DictKeys(ToSet(AGGREGATE_LIST(agency_id)))) == 2;


$min_max_period = SELECT
    clientid AS client_id,
    counterparty_name,
    agency_id AS agency_id,
    agency_name AS agency_name,
    MIN(period) AS min_period,
    MAX(period) AS max_period,
FROM $cd_all_with_tiers
WHERE
    scale == "days"
    AND money IS NOT NULL
    AND money > 0
GROUP BY
    clientid,
    curr_counterparty_name AS counterparty_name,
    agency_id,
    agency_name;

$aux_select = SELECT 
    a.client_domain AS client_domain,
    a.clients_id_list[0] AS client_id_1,
    b.counterparty_name AS counterparty_name_1,
    b.agency_id AS agency_id_1,
    b.agency_name AS agency_name_1,
    b.min_period AS min_period_1,
    b.max_period AS max_period_1,
    a.clients_id_list AS clients_id_list,
    a.agency_id_list AS agency_id_list,
FROM $client_domains AS a 

INNER JOIN 

$min_max_period AS b 

ON a.clients_id_list[0] == b.client_id;

$unsorted_clients = SELECT 
    a.client_domain AS client_domain,
    a.client_id_1 AS client_id_1,
    a.counterparty_name_1 AS counterparty_name_1,
    a.agency_id_1 AS agency_id_1,
    a.agency_name_1 AS agency_name_1,
    a.min_period_1 AS min_period_1,
    a.max_period_1 AS max_period_1,
    a.clients_id_list[1] AS client_id_2,
    b.counterparty_name AS counterparty_name_2,
    b.agency_id AS agency_id_2,
    b.agency_name AS agency_name_2,
    b.min_period AS min_period_2,
    b.max_period AS max_period_2,
    a.clients_id_list AS clients_id_list,
    a.agency_id_list AS agency_id_list
FROM $aux_select AS a

INNER JOIN 

$min_max_period AS b 

ON a.clients_id_list[1] == b.client_id;

$clients_without_mean_budget = SELECT
    client_domain,
    IF(min_period_1 < min_period_2, client_id_1, client_id_2) AS client_id_1,
    IF(min_period_1 < min_period_2, counterparty_name_1, counterparty_name_2) AS counterparty_name_1,
    IF(min_period_1 < min_period_2, agency_id_1, agency_id_2) AS agency_id_1,
    IF(min_period_1 < min_period_2, agency_name_1, agency_name_2) AS agency_name_1,
    IF(min_period_1 < min_period_2, client_id_2, client_id_1) AS client_id_2,
    IF(min_period_1 < min_period_2, counterparty_name_2, counterparty_name_1) AS counterparty_name_2,
    IF(min_period_1 < min_period_2, agency_id_2, agency_id_1) AS agency_id_2,
    IF(min_period_1 < min_period_2, agency_name_2, agency_name_1) AS agency_name_2,
    IF(min_period_1 < min_period_2, min_period_1, min_period_2) AS min_period_1,
    IF(min_period_1 < min_period_2, max_period_1, max_period_2) AS max_period_1,
    IF(min_period_1 < min_period_2, min_period_2, min_period_1) AS min_period_2,
    IF(min_period_1 < min_period_2, max_period_2, max_period_1) AS max_period_2,
    clients_id_list,
    agency_id_list,
FROM $unsorted_clients;

INSERT INTO $write_path WITH TRUNCATE
SELECT
    a.client_domain AS client_domain,
    a.client_id_1 AS client_id_1,
    a.counterparty_name_1 AS counterparty_name_1,
    a.agency_id_1 AS agency_id_1,
    a.agency_name_1 AS agency_name_1,
    a.client_id_2 AS client_id_2,
    a.counterparty_name_2 AS counterparty_name_2,
    a.agency_id_2 AS agency_id_2,
    a.agency_name_2 AS agency_name_2,
    a.min_period_1 AS min_period_1,
    a.max_period_1 AS max_period_1,
    a.min_period_2 AS min_period_2,
    a.max_period_2 AS max_period_2,
    a.clients_id_list AS clients_id_list,
    a.agency_id_list AS agency_id_list,
    b.mean_total_revenue AS mean_total_revenue
FROM $clients_without_mean_budget AS a 

INNER JOIN

$mean_budget_clients AS b 

ON a.client_domain == b.curr_client_main_domain;
