USE hahn;

$path = "//home/geoadv/seregapanov/fraud_flow/agency_stat_2m";
$cd_all_with_tiers = "statbox/cube/daily/comdep/cd_reporting/cd_all_with_tiers";
$prof_agency_path = "home/balance/prod/bo/v_contract_apex_full";

$agency_agregators = SELECT [523581, 28047771, 2371403, 2124001, 67140973, 9830514, 1332316, 35786724, 32805081, 5946133, 1621799, 322057, 472729, 36002706];


-- Список агентств про
$agency_pro_list = SELECT
    AGGREGATE_LIST(DISTINCT agency_id) AS AgencyID
FROM $prof_agency_path
WHERE
    agency_id IS NOT NULL
    AND finish_dt >= "2022-02-01"
    AND (wsale_ag_prm_awrd_sc_tp like "Премиум%" OR wsale_ag_prm_awrd_sc_tp like "РМП%");

-- Список агентств база
$agency_base_list = SELECT
    AGGREGATE_LIST(DISTINCT agency_id) AS AgencyID
FROM $prof_agency_path
WHERE
    agency_id IS NOT NULL
    AND finish_dt >= "2022-02-01"
    AND (wsale_ag_prm_awrd_sc_tp like "Баз%");


INSERT INTO $path WITH TRUNCATE
SELECT  
    date_,
    counterparty,
    domain,
    client_id,
    client_tier,
    client_type,
    agency_id,
    agency_name,
    first_day,
    last_day,
    SUM(money) as money      
FROM $cd_all_with_tiers
WHERE
    CAST(month as date) >= CAST("2022-02-01" as date)
    AND month IS NOT NULL
    AND agency_id IS NOT NULL
    AND money IS NOT NULL
    AND product = 'Общая выручка'
    AND currency = 'rur'
    AND excluded_revenue = "false"
GROUP BY
    month as date_,
    curr_counterparty_name as counterparty,
    curr_client_main_domain as domain,
    clientid as client_id,
    CASE
        WHEN curr_reporting_tier like 'Tier 0' THEN 'Tier 0'
        WHEN curr_reporting_tier like 't1' THEN 'Tier 1'
        WHEN curr_reporting_tier like '%SB%' or curr_reporting_tier like '%SMB%' THEN 'Tier SMB'
        ELSE 'Tier 2'
    END as client_tier,
    CASE
        WHEN operator_role LIKE 'client' THEN 'client'
        WHEN operator_role LIKE 'freelance%' OR curr_agency_tier ILIKE 'самоходно%' THEN 'freelancer'
        WHEN ListHas($agency_agregators, agency_id) THEN 'agregator'
        WHEN ListHas($agency_pro_list, agency_id) THEN "agency (pro)"
        WHEN ListHas($agency_base_list, agency_id) THEN "agency (base)"
        ELSE "agency (other)"
    END AS client_type,
    agency_id,
    COALESCE(agency_name, "-") as agency_name,
    first_day,
    last_day
ORDER BY date_, agency_id
;
